/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker.dao.impl;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.dspace.checker.ChecksumHistory;
import org.dspace.checker.ChecksumResultCode;
import org.dspace.checker.MostRecentChecksum;
import org.dspace.checker.dao.MostRecentChecksumDAO;
import org.dspace.content.Bitstream;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public class MostRecentChecksumDAOImpl
extends AbstractHibernateDAO<MostRecentChecksum>
implements MostRecentChecksumDAO {
    protected MostRecentChecksumDAOImpl() {
    }

    @Override
    public List<MostRecentChecksum> findByNotProcessedInDateRange(Context context, Date startDate, Date endDate) throws SQLException {
        Criteria criteria = this.createCriteria(context, MostRecentChecksum.class);
        criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"toBeProcessed", (Object)false), Restrictions.le((String)"processStartDate", (Object)startDate), Restrictions.gt((String)"processStartDate", (Object)endDate)}));
        criteria.addOrder(Order.asc((String)"bitstream.id"));
        return this.list(criteria);
    }

    @Override
    public MostRecentChecksum findByBitstream(Context context, Bitstream bitstream) throws SQLException {
        Criteria criteria = this.createCriteria(context, MostRecentChecksum.class);
        criteria.add((Criterion)Restrictions.eq((String)"bitstream", (Object)bitstream));
        return (MostRecentChecksum)this.singleResult(criteria);
    }

    @Override
    public List<MostRecentChecksum> findByResultTypeInDateRange(Context context, Date startDate, Date endDate, ChecksumResultCode resultCode) throws SQLException {
        Criteria criteria = this.createCriteria(context, MostRecentChecksum.class);
        criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"checksumResult.resultCode", (Object)((Object)resultCode)), Restrictions.le((String)"processStartDate", (Object)startDate), Restrictions.gt((String)"processStartDate", (Object)endDate)}));
        criteria.addOrder(Order.asc((String)"bitstream.id"));
        return this.list(criteria);
    }

    @Override
    public void deleteByBitstream(Context context, Bitstream bitstream) throws SQLException {
        String hql = "delete from MostRecentChecksum WHERE bitstream=:bitstream";
        Query query = this.createQuery(context, hql);
        query.setParameter("bitstream", (Object)bitstream);
        query.executeUpdate();
    }

    @Override
    public MostRecentChecksum getOldestRecord(Context context) throws SQLException {
        Criteria criteria = this.createCriteria(context, MostRecentChecksum.class);
        criteria.add((Criterion)Restrictions.eq((String)"toBeProcessed", (Object)true));
        criteria.addOrder(Order.asc((String)"processEndDate")).addOrder(Order.asc((String)"bitstream.id"));
        criteria.setMaxResults(1);
        return (MostRecentChecksum)this.singleResult(criteria);
    }

    @Override
    public MostRecentChecksum getOldestRecord(Context context, Date lessThanDate) throws SQLException {
        Criteria criteria = this.createCriteria(context, MostRecentChecksum.class);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"toBeProcessed", (Object)true), (Criterion)Restrictions.lt((String)"processStartDate", (Object)lessThanDate)));
        criteria.addOrder(Order.asc((String)"processEndDate")).addOrder(Order.asc((String)"bitstream.id"));
        criteria.setMaxResults(1);
        return (MostRecentChecksum)this.singleResult(criteria);
    }

    @Override
    public List<MostRecentChecksum> findNotInHistory(Context context) throws SQLException {
        Criteria criteria = this.createCriteria(context, MostRecentChecksum.class);
        DetachedCriteria subCriteria = DetachedCriteria.forClass(ChecksumHistory.class);
        subCriteria.setProjection((Projection)Projections.property((String)"bitstream.id"));
        criteria.add(Property.forName((String)"bitstreamId").notIn(subCriteria));
        return this.list(criteria);
    }
}

