/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.AuthorityVariantsSupport;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.SolrAuthority;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.service.PluginService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public final class ChoiceAuthorityServiceImpl
implements ChoiceAuthorityService {
    private Logger log = Logger.getLogger(ChoiceAuthorityServiceImpl.class);
    protected Map<String, ChoiceAuthority> controller = new HashMap<String, ChoiceAuthority>();
    protected Map<String, String> presentation = new HashMap<String, String>();
    protected Map<String, Boolean> closed = new HashMap<String, Boolean>();
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected PluginService pluginService;
    private final String CHOICES_PLUGIN_PREFIX = "choices.plugin.";
    private final String CHOICES_PRESENTATION_PREFIX = "choices.presentation.";
    private final String CHOICES_CLOSED_PREFIX = "choices.closed.";

    protected ChoiceAuthorityServiceImpl() {
    }

    protected String config2fkey(String field) {
        int dot = field.indexOf(46);
        if (dot < 0) {
            return null;
        }
        String schema = field.substring(0, dot);
        String element = field.substring(dot + 1);
        String qualifier = null;
        dot = element.indexOf(46);
        if (dot >= 0) {
            qualifier = element.substring(dot + 1);
            element = element.substring(0, dot);
        }
        return this.makeFieldKey(schema, element, qualifier);
    }

    @Override
    public Choices getMatches(String schema, String element, String qualifier, String query, Collection collection, int start, int limit, String locale) {
        return this.getMatches(this.makeFieldKey(schema, element, qualifier), query, collection, start, limit, locale);
    }

    @Override
    public Choices getMatches(String fieldKey, String query, Collection collection, int start, int limit, String locale) {
        ChoiceAuthority ma = this.getChoiceAuthorityMap().get(fieldKey);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\".");
        }
        return ma.getMatches(fieldKey, query, collection, start, limit, locale);
    }

    @Override
    public Choices getMatches(String fieldKey, String query, Collection collection, int start, int limit, String locale, boolean externalInput) {
        ChoiceAuthority ma = this.getChoiceAuthorityMap().get(fieldKey);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\".");
        }
        if (externalInput && ma instanceof SolrAuthority) {
            ((SolrAuthority)ma).addExternalResultsInNextMatches();
        }
        return ma.getMatches(fieldKey, query, collection, start, limit, locale);
    }

    @Override
    public Choices getBestMatch(String fieldKey, String query, Collection collection, String locale) {
        ChoiceAuthority ma = this.getChoiceAuthorityMap().get(fieldKey);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\".");
        }
        return ma.getBestMatch(fieldKey, query, collection, locale);
    }

    @Override
    public String getLabel(MetadataValue metadataValue, String locale) {
        return this.getLabel(metadataValue.getMetadataField().toString(), metadataValue.getAuthority(), locale);
    }

    @Override
    public String getLabel(String fieldKey, String authKey, String locale) {
        ChoiceAuthority ma = this.getChoiceAuthorityMap().get(fieldKey);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\".");
        }
        return ma.getLabel(fieldKey, authKey, locale);
    }

    @Override
    public boolean isChoicesConfigured(String fieldKey) {
        return this.getChoiceAuthorityMap().containsKey(fieldKey);
    }

    @Override
    public String getPresentation(String fieldKey) {
        return this.getPresentationMap().get(fieldKey);
    }

    @Override
    public boolean isClosed(String fieldKey) {
        return this.getClosedMap().containsKey(fieldKey) && this.getClosedMap().get(fieldKey) != false;
    }

    @Override
    public List<String> getVariants(MetadataValue metadataValue) {
        ChoiceAuthority ma = this.getChoiceAuthorityMap().get(metadataValue.getMetadataField().toString());
        if (ma instanceof AuthorityVariantsSupport) {
            AuthorityVariantsSupport avs = (AuthorityVariantsSupport)((Object)ma);
            return avs.getVariants(metadataValue.getAuthority(), metadataValue.getLanguage());
        }
        return null;
    }

    protected String makeFieldKey(String schema, String element, String qualifier) {
        if (qualifier == null) {
            return schema + "_" + element;
        }
        return schema + "_" + element + "_" + qualifier;
    }

    private Map<String, ChoiceAuthority> getChoiceAuthorityMap() {
        if (this.controller.isEmpty()) {
            List propKeys = this.configurationService.getPropertyKeys("choices.plugin.");
            for (String key : propKeys) {
                String fkey = this.config2fkey(key.substring("choices.plugin.".length()));
                if (fkey == null) {
                    this.log.warn((Object)("Skipping invalid ChoiceAuthority configuration property: " + key + ": does not have schema.element.qualifier"));
                    continue;
                }
                ChoiceAuthority ma = (ChoiceAuthority)this.pluginService.getNamedPlugin(ChoiceAuthority.class, this.configurationService.getProperty(key));
                if (ma == null) {
                    this.log.warn((Object)("Skipping invalid configuration for " + key + " because named plugin not found: " + this.configurationService.getProperty(key)));
                    continue;
                }
                this.controller.put(fkey, ma);
                this.log.debug((Object)("Choice Control: For field=" + fkey + ", Plugin=" + ma));
            }
        }
        return this.controller;
    }

    private Map<String, String> getPresentationMap() {
        if (this.presentation.isEmpty()) {
            List propKeys = this.configurationService.getPropertyKeys("choices.presentation.");
            for (String key : propKeys) {
                String fkey = this.config2fkey(key.substring("choices.presentation.".length()));
                if (fkey == null) {
                    this.log.warn((Object)("Skipping invalid ChoiceAuthority configuration property: " + key + ": does not have schema.element.qualifier"));
                    continue;
                }
                this.presentation.put(fkey, this.configurationService.getProperty(key));
            }
        }
        return this.presentation;
    }

    private Map<String, Boolean> getClosedMap() {
        if (this.closed.isEmpty()) {
            List propKeys = this.configurationService.getPropertyKeys("choices.closed.");
            for (String key : propKeys) {
                String fkey = this.config2fkey(key.substring("choices.closed.".length()));
                if (fkey == null) {
                    this.log.warn((Object)("Skipping invalid ChoiceAuthority configuration property: " + key + ": does not have schema.element.qualifier"));
                    continue;
                }
                this.closed.put(fkey, this.configurationService.getBooleanProperty(key));
            }
        }
        return this.closed;
    }
}

