/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.dao.MetadataValueDAO;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class MetadataValueDAOImpl
extends AbstractHibernateDAO<MetadataValue>
implements MetadataValueDAO {
    protected MetadataValueDAOImpl() {
    }

    @Override
    public List<MetadataValue> findByField(Context context, MetadataField metadataField) throws SQLException {
        Criteria criteria = this.createCriteria(context, MetadataValue.class);
        criteria.add((Criterion)Restrictions.eq((String)"metadataField.id", (Object)metadataField.getID()));
        criteria.setFetchMode("metadataField", FetchMode.JOIN);
        return this.list(criteria);
    }

    @Override
    public Iterator<MetadataValue> findByValueLike(Context context, String value) throws SQLException {
        String queryString = "SELECT m FROM MetadataValue m JOIN m.metadataField f WHERE m.value like concat('%', concat(:searchString,'%')) ORDER BY m.id ASC";
        Query query = this.createQuery(context, queryString);
        query.setString("searchString", value);
        return this.iterate(query);
    }

    @Override
    public void deleteByMetadataField(Context context, MetadataField metadataField) throws SQLException {
        String queryString = "delete from MetadataValue where metadataField= :metadataField";
        Query query = this.createQuery(context, queryString);
        query.setParameter("metadataField", (Object)metadataField);
        query.executeUpdate();
    }

    @Override
    public MetadataValue getMinimum(Context context, int metadataFieldId) throws SQLException {
        String queryString = "SELECT m FROM MetadataValue m JOIN FETCH m.metadataField WHERE m.metadataField.id = :metadata_field_id ORDER BY text_value";
        Query query = this.createQuery(context, queryString);
        query.setParameter("metadata_field_id", (Object)metadataFieldId);
        query.setMaxResults(1);
        return (MetadataValue)query.uniqueResult();
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM MetadataValue"));
    }
}

