/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public abstract class AbstractHibernateDSODAO<T extends DSpaceObject>
extends AbstractHibernateDAO<T> {
    public T findByLegacyId(Context context, int legacyId, Class<T> clazz) throws SQLException {
        Criteria criteria = this.createCriteria(context, clazz);
        criteria.add((Criterion)Restrictions.eq((String)"legacyId", (Object)legacyId));
        return (T)((DSpaceObject)this.uniqueResult(criteria));
    }

    protected void addMetadataLeftJoin(StringBuilder query, String tableIdentifier, Collection<MetadataField> metadataFields) {
        for (MetadataField metadataField : metadataFields) {
            query.append(" left join ").append(tableIdentifier).append(".metadata ").append(metadataField.toString());
            query.append(" WITH ").append(metadataField.toString()).append(".metadataField.id").append(" = :").append(metadataField.toString());
        }
    }

    protected void addMetadataValueWhereQuery(StringBuilder query, List<MetadataField> metadataFields, String operator, String additionalWhere) {
        if (CollectionUtils.isNotEmpty(metadataFields) || StringUtils.isNotBlank((CharSequence)additionalWhere)) {
            query.append(" WHERE ");
            for (int i = 0; i < metadataFields.size(); ++i) {
                MetadataField metadataField = metadataFields.get(i);
                if (!StringUtils.isNotBlank((CharSequence)operator)) continue;
                query.append(" (");
                query.append("lower(STR(" + metadataField.toString()).append(".value)) ").append(operator).append(" lower(:queryParam)");
                query.append(")");
                if (i >= metadataFields.size() - 1) continue;
                query.append(" OR ");
            }
            if (StringUtils.isNotBlank((CharSequence)additionalWhere)) {
                if (CollectionUtils.isNotEmpty(metadataFields)) {
                    query.append(" OR ");
                }
                query.append(additionalWhere);
            }
        }
    }

    protected void addMetadataSortQuery(StringBuilder query, List<MetadataField> metadataSortFields, List<String> columnSortFields) {
        this.addMetadataSortQuery(query, metadataSortFields, columnSortFields, ListUtils.EMPTY_LIST);
    }

    protected void addMetadataSortQuery(StringBuilder query, List<MetadataField> metadataSortFields, List<String> columnSortFields, List<String> direction) {
        block3: {
            block2: {
                if (!CollectionUtils.isNotEmpty(metadataSortFields)) break block2;
                query.append(" ORDER BY ");
                for (int i = 0; i < metadataSortFields.size(); ++i) {
                    MetadataField metadataField = metadataSortFields.get(i);
                    query.append("STR(").append(metadataField.toString()).append(".value)");
                    String dir = direction.size() > i ? " " + direction.get(i) : "";
                    query.append(dir);
                    if (i == metadataSortFields.size() - 1) continue;
                    query.append(",");
                }
                break block3;
            }
            if (!CollectionUtils.isNotEmpty(columnSortFields)) break block3;
            query.append(" ORDER BY ");
            for (int i = 0; i < columnSortFields.size(); ++i) {
                String sortField = columnSortFields.get(i);
                query.append(sortField);
                if (i == columnSortFields.size() - 1) continue;
                query.append(",");
            }
        }
    }
}

