/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import com.coverity.security.Escape;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.rmi.dgc.VMID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class Utils {
    private static Logger log = Logger.getLogger(Utils.class);
    private static final Pattern DURATION_PATTERN = Pattern.compile("(\\d+)([smhdwy])");
    private static final long MS_IN_SECOND = 1000L;
    private static final long MS_IN_MINUTE = 60000L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final long MS_IN_DAY = 86400000L;
    private static final long MS_IN_WEEK = 604800000L;
    private static final long MS_IN_YEAR = 31536000000L;
    private static int counter = 0;
    private static Random random = new Random();
    private static VMID vmid = new VMID();
    private static SimpleDateFormat[] parseFmt = new SimpleDateFormat[]{new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss.SSSz"), new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssz"), new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss.SSS"), new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss")};
    private static SimpleDateFormat outFmtSecond = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssZ");
    private static SimpleDateFormat outFmtMillisec = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss.SSSZ");
    private static Calendar outCal = GregorianCalendar.getInstance();

    private Utils() {
    }

    public static String getMD5(String data) {
        return Utils.getMD5(data.getBytes());
    }

    public static String getMD5(byte[] data) {
        return Utils.toHex(Utils.getMD5Bytes(data));
    }

    public static byte[] getMD5Bytes(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            return digest.digest(data);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String toHex(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int low = data[i] & 0xF;
            int high = data[i] & 0xF0;
            result.append(Integer.toHexString(high).substring(0, 1));
            result.append(Integer.toHexString(low));
        }
        return result.toString();
    }

    public static String generateKey() {
        return new BigInteger(Utils.generateBytesKey()).abs().toString();
    }

    public static String generateHexKey() {
        return Utils.toHex(Utils.generateBytesKey());
    }

    public static synchronized byte[] generateBytesKey() {
        byte[] junk = new byte[16];
        random.nextBytes(junk);
        String input = new StringBuffer().append(vmid).append(new Date()).append(Arrays.toString(junk)).append(counter++).toString();
        return Utils.getMD5Bytes(input.getBytes());
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int count;
        int BUFFER_SIZE = 4096;
        byte[] buffer = new byte[4096];
        while (-1 != (count = input.read(buffer, 0, 4096))) {
            output.write(buffer, 0, count);
        }
    }

    public static void bufferedCopy(InputStream source, OutputStream destination) throws IOException {
        BufferedInputStream input = new BufferedInputStream(source);
        BufferedOutputStream output = new BufferedOutputStream(destination);
        Utils.copy(input, output);
        output.flush();
    }

    public static String addEntities(String value) {
        return Escape.html((String)value);
    }

    public static long parseDuration(String duration) throws ParseException {
        Matcher m = DURATION_PATTERN.matcher(duration.trim());
        if (!m.matches()) {
            throw new ParseException("'" + duration + "' is not a valid duration definition", 0);
        }
        String units = m.group(2);
        long multiplier = 1000L;
        if ("s".equals(units)) {
            multiplier = 1000L;
        } else if ("m".equals(units)) {
            multiplier = 60000L;
        } else if ("h".equals(units)) {
            multiplier = 3600000L;
        } else if ("d".equals(units)) {
            multiplier = 86400000L;
        } else if ("w".equals(units)) {
            multiplier = 604800000L;
        } else if ("y".equals(units)) {
            multiplier = 31536000000L;
        } else {
            throw new ParseException(units + " is not a valid time unit (must be 'y', 'w', 'd', 'h', 'm' or 's')", duration.indexOf(units));
        }
        long qint = Long.parseLong(m.group(1));
        return qint * multiplier;
    }

    public static synchronized Date parseISO8601Date(String s) {
        char tzSign = s.charAt(s.length() - 6);
        if (s.endsWith("Z")) {
            s = s.substring(0, s.length() - 1) + "GMT+00:00";
        } else if (tzSign == '-' || tzSign == '+') {
            s = s.substring(0, s.length() - 6) + "GMT" + s.substring(s.length() - 6);
        }
        ParseException lastError = null;
        for (int i = 0; i < parseFmt.length; ++i) {
            try {
                return parseFmt[i].parse(s);
            }
            catch (ParseException e) {
                lastError = e;
                continue;
            }
        }
        if (lastError != null) {
            log.error((Object)"Error parsing date:", (Throwable)lastError);
        }
        return null;
    }

    public static synchronized String formatISO8601Date(Date d) {
        outCal.setTime(d);
        String result = outCal.get(14) == 0 ? outFmtSecond.format(d) : outFmtMillisec.format(d);
        int rl = result.length();
        return result.substring(0, rl - 2) + ":" + result.substring(rl - 2);
    }

    public static <E> Collection<E> emptyIfNull(Collection<E> collection) {
        return collection == null ? Collections.emptyList() : collection;
    }
}

