/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.curate.CurationTask;
import org.dspace.curate.Curator;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public abstract class AbstractCurationTask
implements CurationTask {
    protected Curator curator = null;
    protected String taskId = null;
    private static Logger log = Logger.getLogger(AbstractCurationTask.class);
    protected CommunityService communityService;
    protected ItemService itemService;
    protected HandleService handleService;
    protected ConfigurationService configurationService;

    @Override
    public void init(Curator curator, String taskId) throws IOException {
        this.curator = curator;
        this.taskId = taskId;
        this.communityService = ContentServiceFactory.getInstance().getCommunityService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.handleService = HandleServiceFactory.getInstance().getHandleService();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    }

    @Override
    public abstract int perform(DSpaceObject var1) throws IOException;

    protected void distribute(DSpaceObject dso) throws IOException {
        try {
            this.performObject(dso);
            int type = dso.getType();
            if (3 == type) {
                Iterator<Item> iter = this.itemService.findByCollection(Curator.curationContext(), (Collection)dso);
                while (iter.hasNext()) {
                    this.performObject(iter.next());
                }
            } else if (4 == type) {
                Community comm = (Community)dso;
                for (Community subcomm : comm.getSubcommunities()) {
                    this.distribute(subcomm);
                }
                for (Collection coll : comm.getCollections()) {
                    this.distribute(coll);
                }
            } else if (5 == type) {
                List<Community> topComm = this.communityService.findAllTop(Curator.curationContext());
                for (Community comm : topComm) {
                    this.distribute(comm);
                }
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
    }

    protected void performObject(DSpaceObject dso) throws SQLException, IOException {
        if (dso.getType() == 2) {
            this.performItem((Item)dso);
        }
    }

    protected void performItem(Item item) throws SQLException, IOException {
    }

    @Override
    public int perform(Context ctx, String id) throws IOException {
        DSpaceObject dso = this.dereference(ctx, id);
        return dso != null ? this.perform(dso) : 1;
    }

    protected DSpaceObject dereference(Context ctx, String id) throws IOException {
        try {
            return this.handleService.resolveToObject(ctx, id);
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
    }

    protected void report(String message) {
        this.curator.report(message);
    }

    protected void setResult(String result) {
        this.curator.setResult(this.taskId, result);
    }

    protected String taskProperty(String name) {
        if (StringUtils.isNotBlank((String)this.taskId)) {
            return this.configurationService.getProperty(this.taskId + "." + name);
        }
        return this.configurationService.getProperty(name);
    }

    protected int taskIntProperty(String name, int defaultValue) {
        if (StringUtils.isNotBlank((String)this.taskId)) {
            return this.configurationService.getIntProperty(this.taskId + "." + name, defaultValue);
        }
        return this.configurationService.getIntProperty(name, defaultValue);
    }

    protected long taskLongProperty(String name, long defaultValue) {
        if (StringUtils.isNotBlank((String)this.taskId)) {
            return this.configurationService.getLongProperty(this.taskId + "." + name, defaultValue);
        }
        return this.configurationService.getLongProperty(name, defaultValue);
    }

    protected boolean taskBooleanProperty(String name, boolean defaultValue) {
        if (StringUtils.isNotBlank((String)this.taskId)) {
            return this.configurationService.getBooleanProperty(this.taskId + "." + name, defaultValue);
        }
        return this.configurationService.getBooleanProperty(name, defaultValue);
    }

    protected String[] taskArrayProperty(String name) {
        if (StringUtils.isNotBlank((String)this.taskId)) {
            return this.configurationService.getArrayProperty(this.taskId + "." + name);
        }
        return this.configurationService.getArrayProperty(name);
    }
}

