/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.service.components.Destroyable;
import org.dspace.importer.external.service.components.MetadataSource;
import org.springframework.beans.factory.annotation.Autowired;

public class ImportService
implements Destroyable {
    private HashMap<String, MetadataSource> importSources = new HashMap();
    Logger log = Logger.getLogger(ImportService.class);
    protected static final String ANY = "*";

    @Autowired(required=false)
    public void setImportSources(List<MetadataSource> importSources) throws MetadataSourceException {
        this.log.info((Object)("Loading " + importSources.size() + " import sources."));
        for (MetadataSource metadataSource : importSources) {
            this.importSources.put(metadataSource.getImportSource(), metadataSource);
        }
    }

    protected Map<String, MetadataSource> getImportSources() {
        return Collections.unmodifiableMap(this.importSources);
    }

    protected Collection<MetadataSource> matchingImports(String uri) {
        if (ANY.equals(uri)) {
            return this.importSources.values();
        }
        if (this.importSources.containsKey(uri)) {
            return Collections.singletonList(this.importSources.get(uri));
        }
        return Collections.emptyList();
    }

    public Collection<ImportRecord> findMatchingRecords(String uri, Item item) throws MetadataSourceException {
        try {
            LinkedList<ImportRecord> recordList = new LinkedList<ImportRecord>();
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                recordList.addAll(metadataSource.findMatchingRecords(item));
            }
            return recordList;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public Collection<ImportRecord> findMatchingRecords(String uri, Query query) throws MetadataSourceException {
        try {
            LinkedList<ImportRecord> recordList = new LinkedList<ImportRecord>();
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                recordList.addAll(metadataSource.findMatchingRecords(query));
            }
            return recordList;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public int getNbRecords(String uri, String query) throws MetadataSourceException {
        try {
            int total = 0;
            for (MetadataSource MetadataSource2 : this.matchingImports(uri)) {
                total += MetadataSource2.getNbRecords(query);
            }
            return total;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public int getNbRecords(String uri, Query query) throws MetadataSourceException {
        try {
            int total = 0;
            for (MetadataSource MetadataSource2 : this.matchingImports(uri)) {
                total += MetadataSource2.getNbRecords(query);
            }
            return total;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public Collection<ImportRecord> getRecords(String uri, String query, int start, int count) throws MetadataSourceException {
        try {
            LinkedList<ImportRecord> recordList = new LinkedList<ImportRecord>();
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                recordList.addAll(metadataSource.getRecords(query, start, count));
            }
            return recordList;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public Collection<ImportRecord> getRecords(String uri, Query query) throws MetadataSourceException {
        try {
            LinkedList<ImportRecord> recordList = new LinkedList<ImportRecord>();
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                recordList.addAll(metadataSource.getRecords(query));
            }
            return recordList;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public ImportRecord getRecord(String uri, String id) throws MetadataSourceException {
        try {
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                if (metadataSource.getRecord(id) == null) continue;
                return metadataSource.getRecord(id);
            }
            return null;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public ImportRecord getRecord(String uri, Query query) throws MetadataSourceException {
        try {
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                if (metadataSource.getRecord(query) == null) continue;
                return metadataSource.getRecord(query);
            }
            return null;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public Collection<String> getImportUrls() {
        return this.importSources.keySet();
    }

    @Override
    public void destroy() throws Exception {
        for (MetadataSource metadataSource : this.importSources.values()) {
            if (!(metadataSource instanceof Destroyable)) continue;
            ((Destroyable)((Object)metadataSource)).destroy();
        }
    }
}

