/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.curate.Curator;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.submit.step.AccessStep;
import org.dspace.submit.step.UploadStep;

public class UploadWithEmbargoStep
extends UploadStep {
    public static final int STATUS_EDIT_POLICIES = 30;
    public static final int STATUS_EDIT_POLICIES_ERROR_SELECT_GROUP = 31;
    public static final int STATUS_EDIT_POLICIES_DUPLICATED_POLICY = 32;
    public static final int STATUS_EDIT_POLICY_ERROR_SELECT_GROUP = 33;
    public static final int STATUS_EDIT_POLICY_DUPLICATED_POLICY = 34;
    private static Logger log = Logger.getLogger(UploadWithEmbargoStep.class);
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        List<Bundle> bundles;
        int status;
        int status2;
        int status3;
        String buttonPressed = Util.getSubmitButton(request, "submit_next");
        Item item = subInfo.getSubmissionItem().getItem();
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1 && (status3 = this.processUploadFile(context, request, response, subInfo)) != 0) {
            return status3;
        }
        if (buttonPressed.startsWith("submit_jump_") || buttonPressed.startsWith("submit_prev")) {
            if (this.fileRequired && !this.itemService.hasUploadedFiles(item)) {
                return 5;
            }
            return 0;
        }
        int result = this.editBitstreamPolicies(request, context, subInfo, buttonPressed);
        if (result != -1) {
            return result;
        }
        if (request.getParameter("bitstream_id") != null) {
            if (buttonPressed.equals("submit_edit_cancel")) {
                subInfo.setBitstream(null);
                return 25;
            }
            Bitstream b = (Bitstream)this.bitstreamService.find(context, Util.getUUIDParameter(request, "bitstream_id"));
            subInfo.setBitstream(b);
        } else if (buttonPressed.startsWith("submit_edit_")) {
            String bitstreamID = buttonPressed.substring("submit_edit_".length());
            Bitstream b = (Bitstream)this.bitstreamService.find(context, UUID.fromString(bitstreamID));
            subInfo.setBitstream(b);
            return 20;
        }
        if (buttonPressed.equalsIgnoreCase("submit_remove_selected")) {
            if (request.getParameter("remove") != null) {
                String[] removeIDs = request.getParameterValues("remove");
                for (int i = 0; i < removeIDs.length; ++i) {
                    UUID id = UUID.fromString(removeIDs[i]);
                    status2 = this.processRemoveFile(context, item, id);
                    if (status2 == 0) continue;
                    return status2;
                }
                subInfo.setBitstream(null);
            }
        } else if (buttonPressed.startsWith("submit_remove_")) {
            UUID id = UUID.fromString(buttonPressed.substring(14));
            int status4 = this.processRemoveFile(context, item, id);
            if (status4 != 0) {
                return status4;
            }
            subInfo.setBitstream(null);
        }
        Enumeration parameterNames = request.getParameterNames();
        HashMap<String, String> descriptions = new HashMap<String, String>();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            if (!StringUtils.startsWithIgnoreCase((String)name, (String)"description[")) continue;
            descriptions.put(name.substring("description[".length(), name.length() - 1), request.getParameter(name));
        }
        if (!descriptions.isEmpty()) {
            if (item != null) {
                List<Bundle> bundles2 = this.itemService.getBundles(item, "ORIGINAL");
                for (Bundle bundle : bundles2) {
                    List<Bitstream> bitstreams = bundle.getBitstreams();
                    for (Bitstream bitstream : bitstreams) {
                        if (!descriptions.containsKey(bitstream.getName())) continue;
                        bitstream.setDescription(context, (String)descriptions.get(bitstream.getName()));
                        this.bitstreamService.update(context, bitstream);
                    }
                }
            }
            return 0;
        }
        String fileDescription = request.getParameter("description");
        if (fileDescription != null && fileDescription.length() > 0 && (status2 = this.processSaveFileDescription(context, request, response, subInfo)) != 0) {
            return status2;
        }
        int formatTypeID = Util.getIntParameter(request, "format");
        String formatDesc = request.getParameter("format_description");
        if ((formatTypeID >= 0 || formatDesc != null && formatDesc.length() > 0) && (status = this.processSaveFileFormat(context, request, response, subInfo)) != 0) {
            return status;
        }
        if (buttonPressed.equals("submit_save")) {
            this.processAccessFields(context, request, subInfo, subInfo.getBitstream());
        }
        if (request.getParameter("primary_bitstream_id") != null && (bundles = this.itemService.getBundles(item, "ORIGINAL")).size() > 0) {
            bundles.get(0).setPrimaryBitstreamID((Bitstream)this.bitstreamService.find(context, Util.getUUIDParameter(request, "primary_bitstream_id")));
            this.bundleService.update(context, (DSpaceObject)bundles.get(0));
        }
        if (this.fileRequired && !this.itemService.hasUploadedFiles(item)) {
            return 5;
        }
        return 0;
    }

    @Override
    public int processUploadFile(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean formatKnown = true;
        boolean fileOK = false;
        BitstreamFormat bf = null;
        Bitstream b = null;
        Enumeration attNames = request.getAttributeNames();
        while (attNames.hasMoreElements()) {
            String attr = (String)attNames.nextElement();
            if (!attr.endsWith("-path")) continue;
            String param = attr.replace("-path", "");
            String filePath = (String)request.getAttribute(param + "-path");
            InputStream fileInputStream = (InputStream)request.getAttribute(param + "-inputstream");
            String fileDescription = (String)request.getAttribute(param + "-description");
            if (fileDescription == null || fileDescription.length() == 0) {
                fileDescription = request.getParameter("description");
            }
            if (filePath == null || fileInputStream == null) {
                return 2;
            }
            if (subInfo == null) {
                return 1;
            }
            Item item = subInfo.getSubmissionItem().getItem();
            List<Bundle> bundles = this.itemService.getBundles(item, "ORIGINAL");
            b = bundles.size() < 1 ? this.itemService.createSingleBitstream(context, fileInputStream, item, "ORIGINAL") : this.bitstreamService.create(context, bundles.get(0), fileInputStream);
            String noPath = filePath;
            while (noPath.indexOf(47) > -1) {
                noPath = noPath.substring(noPath.indexOf(47) + 1);
            }
            while (noPath.indexOf(92) > -1) {
                noPath = noPath.substring(noPath.indexOf(92) + 1);
            }
            b.setName(context, noPath);
            b.setSource(context, filePath);
            b.setDescription(context, fileDescription);
            bf = this.bitstreamFormatService.guessFormat(context, b);
            b.setFormat(context, bf);
            this.bitstreamService.update(context, b);
            this.itemService.update(context, item);
            this.processAccessFields(context, request, subInfo, b);
            if (bf != null && bf.isInternal()) {
                log.warn((Object)"Attempt to upload file format marked as internal system use only");
                this.backoutBitstream(context, subInfo, b, item);
                return 2;
            }
            if (this.configurationService.getBooleanProperty("submission-curation.virus-scan")) {
                Curator curator = new Curator();
                curator.addTask("vscan").curate(item);
                int status = curator.getStatus("vscan");
                if (status == -1) {
                    this.backoutBitstream(context, subInfo, b, item);
                    return 14;
                }
                if (status == 1) {
                    this.backoutBitstream(context, subInfo, b, item);
                    return 16;
                }
            }
            context.dispatchEvents();
            subInfo.setBitstream(b);
            if (bf != null) continue;
            return 10;
        }
        return 0;
    }

    private void processAccessFields(Context context, HttpServletRequest request, SubmissionInfo subInfo, Bitstream b) throws SQLException, AuthorizeException {
        boolean isAdvancedFormEnabled = this.configurationService.getBooleanProperty("webui.submission.restrictstep.enableAdvancedForm", false);
        if (!isAdvancedFormEnabled) {
            Date startDate = null;
            try {
                startDate = DateUtils.parseDate((String)request.getParameter("embargo_until_date"), (String[])new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy"});
            }
            catch (Exception exception) {
                // empty catch block
            }
            String reason = request.getParameter("reason");
            this.authorizeService.generateAutomaticPolicies(context, startDate, reason, b, (Collection)this.handleService.resolveToObject(context, subInfo.getCollectionHandle()));
        }
    }

    private int editBitstreamPolicies(HttpServletRequest request, Context context, SubmissionInfo subInfo, String buttonPressed) throws SQLException, AuthorizeException {
        if (buttonPressed.equals("bitstream_list_submit_return")) {
            return 0;
        }
        if (buttonPressed.startsWith("submit_editPolicy_")) {
            UUID bitstreamID = UUID.fromString(buttonPressed.substring("submit_editPolicy_".length()));
            Bitstream b = (Bitstream)this.bitstreamService.find(context, bitstreamID);
            subInfo.setBitstream(b);
            return 30;
        }
        if (buttonPressed.startsWith("submit_add_policy")) {
            ResourcePolicy rp;
            Bitstream b = (Bitstream)this.bitstreamService.find(context, Util.getUUIDParameter(request, "bitstream_id"));
            subInfo.setBitstream(b);
            int result = -1;
            result = AccessStep.checkForm(request);
            if (result != 0) {
                return result;
            }
            Date dateStartDate = AccessStep.getEmbargoUntil(request);
            String reason = request.getParameter("reason");
            String name = request.getParameter("name");
            Group group = null;
            if (request.getParameter("group_id") != null) {
                try {
                    group = (Group)this.groupService.find(context, Util.getUUIDParameter(request, "group_id"));
                }
                catch (NumberFormatException nfe) {
                    return 31;
                }
            }
            if ((rp = this.authorizeService.createOrModifyPolicy(null, context, name, group, null, dateStartDate, 0, reason, b)) == null) {
                return 32;
            }
            this.resourcePolicyService.update(context, rp);
            context.dispatchEvents();
            return 30;
        }
        if (AccessStep.wasEditPolicyPressed(context, buttonPressed, subInfo)) {
            Bitstream b = (Bitstream)this.bitstreamService.find(context, Util.getUUIDParameter(request, "bitstream_id"));
            subInfo.setBitstream(b);
            return 10;
        }
        if (AccessStep.comeFromEditPolicy(request)) {
            Bitstream b = (Bitstream)this.bitstreamService.find(context, Util.getUUIDParameter(request, "bitstream_id"));
            subInfo.setBitstream(b);
            String reason = request.getParameter("reason");
            String name = request.getParameter("name");
            Group group = this.groupService.findByName(context, "Anonymous");
            if (request.getParameter("group_id") != null) {
                try {
                    group = (Group)this.groupService.find(context, UUID.fromString(request.getParameter("group_id")));
                }
                catch (NumberFormatException nfe) {
                    return 31;
                }
            }
            if (AccessStep.saveOrCancelEditPolicy(context, request, subInfo, buttonPressed, b, name, group, reason) == 5) {
                return 34;
            }
            return 30;
        }
        if (AccessStep.wasRemovePolicyPressed(buttonPressed)) {
            Bitstream b = (Bitstream)this.bitstreamService.find(context, Util.getUUIDParameter(request, "bitstream_id"));
            subInfo.setBitstream(b);
            AccessStep.removePolicy(context, buttonPressed);
            context.dispatchEvents();
            return 30;
        }
        return -1;
    }
}

