/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.dspace.workflow.WorkflowException;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.processingaction.ProcessingAction;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class ScoreEvaluationAction
extends ProcessingAction {
    private int minimumAcceptanceScore;

    @Override
    public void activate(Context c, XmlWorkflowItem wf) throws SQLException, IOException, AuthorizeException, WorkflowException {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException, WorkflowException {
        boolean hasPassed = false;
        List<MetadataValue> scores = this.itemService.getMetadata(wfi.getItem(), "workflow", "score", null, "*");
        if (0 < scores.size()) {
            int totalScoreCount = 0;
            for (MetadataValue score : scores) {
                totalScoreCount += Integer.parseInt(score.getValue());
            }
            int scoreMean = totalScoreCount / scores.size();
            hasPassed = this.getMinimumAcceptanceScore() <= scoreMean;
            this.itemService.clearMetadata(c, wfi.getItem(), "workflow", "score", null, "*");
            String provDescription = this.getProvenanceStartId() + " Approved for entry into archive with a score of: " + scoreMean;
            this.itemService.addMetadata(c, wfi.getItem(), "dc", "description", "provenance", "en", provDescription);
            this.itemService.update(c, wfi.getItem());
        }
        if (hasPassed) {
            return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
        }
        XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().sendWorkflowItemBackSubmission(c, wfi, c.getCurrentUser(), this.getProvenanceStartId(), "The item was reject due to a bad review score.");
        return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
    }

    public int getMinimumAcceptanceScore() {
        return this.minimumAcceptanceScore;
    }

    public void setMinimumAcceptanceScore(int minimumAcceptanceScore) {
        this.minimumAcceptanceScore = minimumAcceptanceScore;
    }
}

