/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.dspace.app.mediafilter.JPEGFilter;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.content.Item;

public class PDFBoxThumbnail
extends MediaFilter {
    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".jpg";
    }

    @Override
    public String getBundleName() {
        return "THUMBNAIL";
    }

    @Override
    public String getFormatString() {
        return "JPEG";
    }

    @Override
    public String getDescription() {
        return "Generated Thumbnail";
    }

    @Override
    public InputStream getDestinationStream(Item currentItem, InputStream source, boolean verbose) throws Exception {
        PDDocument doc = PDDocument.load((InputStream)source);
        PDFRenderer renderer = new PDFRenderer(doc);
        BufferedImage buf = renderer.renderImage(0);
        doc.close();
        JPEGFilter jpegFilter = new JPEGFilter();
        return jpegFilter.getThumb(currentItem, buf, verbose);
    }
}

