/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;

public class GoogleBitstreamComparator
implements Comparator<Bitstream> {
    private static final Logger log = Logger.getLogger(GoogleBitstreamComparator.class);
    HashMap<String, Integer> priorityMap = new HashMap();
    private Context context;

    public GoogleBitstreamComparator(Context context, Map<String, String> googleScholarSettings) {
        String[] shortDescriptions;
        this.context = context;
        if (googleScholarSettings.containsKey("citation.prioritized_types")) {
            shortDescriptions = this.splitAndTrim(googleScholarSettings.get("citation.prioritized_types"));
        } else {
            log.warn((Object)"Please define citation.prioritized_types in google-metadata.properties");
            shortDescriptions = new String[]{};
        }
        int priority = 1;
        for (String s : shortDescriptions) {
            try {
                BitstreamFormat format = ContentServiceFactory.getInstance().getBitstreamFormatService().findByShortDescription(context, s);
                if (format != null) {
                    this.priorityMap.put(format.getMIMEType(), priority);
                } else {
                    log.warn((Object)(s + " is not a valid short description, please add it to bitstream-formats.xml"));
                }
                ++priority;
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    private String[] splitAndTrim(String toSplit) {
        if (toSplit != null) {
            String[] splittedArray = toSplit.split(",");
            for (int i = 0; i < splittedArray.length; ++i) {
                splittedArray[i] = splittedArray[i].trim();
            }
            return splittedArray;
        }
        return new String[0];
    }

    @Override
    public int compare(Bitstream b1, Bitstream b2) {
        int priority2;
        int priority1 = this.getPriorityFromBitstream(b1);
        if (priority1 > (priority2 = this.getPriorityFromBitstream(b2))) {
            return 1;
        }
        if (priority1 == priority2) {
            if (b1.getSizeBytes() <= b2.getSizeBytes()) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    private int getPriorityFromBitstream(Bitstream bitstream) {
        try {
            String check = bitstream.getFormat(this.context).getMIMEType();
            if (this.priorityMap.containsKey(bitstream.getFormat(this.context).getMIMEType())) {
                return this.priorityMap.get(bitstream.getFormat(this.context).getMIMEType());
            }
            return Integer.MAX_VALUE;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            return Integer.MAX_VALUE;
        }
    }
}

