/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.app.util.service.MetadataExposureService;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class MetadataExposureServiceImpl
implements MetadataExposureService {
    protected Logger log = Logger.getLogger(MetadataExposureServiceImpl.class);
    protected Map<String, Set<String>> hiddenElementSets = null;
    protected Map<String, Map<String, Set<String>>> hiddenElementMaps = null;
    protected final String CONFIG_PREFIX = "metadata.hide.";
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;

    protected MetadataExposureServiceImpl() {
    }

    @Override
    public boolean isHidden(Context context, String schema, String element, String qualifier) throws SQLException {
        boolean hidden = false;
        if (!this.isInitialized()) {
            this.init();
        }
        if (qualifier == null) {
            Set<String> elts = this.hiddenElementSets.get(schema);
            hidden = elts != null && elts.contains(element);
        } else {
            Map<String, Set<String>> elts = this.hiddenElementMaps.get(schema);
            if (elts == null) {
                return false;
            }
            Set<String> quals = elts.get(element);
            boolean bl = hidden = quals != null && quals.contains(qualifier);
        }
        if (hidden && context != null) {
            hidden = !this.authorizeService.isAdmin(context);
        }
        return hidden;
    }

    protected boolean isInitialized() {
        return this.hiddenElementSets != null;
    }

    protected synchronized void init() {
        if (!this.isInitialized()) {
            this.hiddenElementSets = new HashMap<String, Set<String>>();
            this.hiddenElementMaps = new HashMap<String, Map<String, Set<String>>>();
            List propertyKeys = this.configurationService.getPropertyKeys();
            for (String key : propertyKeys) {
                if (!key.startsWith("metadata.hide.") || !this.configurationService.getBooleanProperty(key, true)) continue;
                String mdField = key.substring("metadata.hide.".length());
                String[] segment = mdField.split("\\.", 3);
                if (segment.length == 3) {
                    Map<String, Set<String>> eltMap = this.hiddenElementMaps.get(segment[0]);
                    if (eltMap == null) {
                        eltMap = new HashMap<String, Set<String>>();
                        this.hiddenElementMaps.put(segment[0], eltMap);
                    }
                    if (!eltMap.containsKey(segment[1])) {
                        eltMap.put(segment[1], new HashSet());
                    }
                    eltMap.get(segment[1]).add(segment[2]);
                    continue;
                }
                if (segment.length == 2) {
                    if (!this.hiddenElementSets.containsKey(segment[0])) {
                        this.hiddenElementSets.put(segment[0], new HashSet());
                    }
                    this.hiddenElementSets.get(segment[0]).add(segment[1]);
                    continue;
                }
                this.log.warn((Object)("Bad format in hidden metadata directive, field=\"" + mdField + "\", config property=" + key));
            }
        }
    }
}

