/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.dspace.app.util.Util;
import org.dspace.app.util.WebApp;
import org.dspace.app.util.factory.UtilServiceFactory;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class Version {
    public static void main(String[] argv) throws IOException {
        Properties sys = System.getProperties();
        System.out.printf("DSpace version:  %s\n", Util.getSourceVersion());
        Properties scm = new Properties();
        InputStream propStream = Version.class.getResourceAsStream("/scm.properties");
        if (null != propStream) {
            scm.load(propStream);
        }
        System.out.printf("  SCM revision:  %s\n", scm.get("revision"));
        System.out.printf("    SCM branch:  %s\n", scm.get("branch"));
        System.out.printf("            OS:  %s(%s) version %s\n", sys.get("os.name"), sys.get("os.arch"), sys.get("os.version"));
        List<WebApp> apps = UtilServiceFactory.getInstance().getWebAppService().getApps();
        System.out.println("  Applications:");
        for (WebApp app : apps) {
            System.out.printf("                %s at %s\n", app.getAppName(), app.getUrl());
        }
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        String[] consumers = config.getArrayProperty("event.dispatcher.default.consumers");
        String discoveryStatus = "not enabled.";
        for (String consumer : consumers) {
            if (!consumer.equals("discovery")) continue;
            discoveryStatus = "enabled.";
            break;
        }
        System.out.println("     Discovery:  " + discoveryStatus);
        System.out.printf("           JRE:  %s version %s\n", sys.get("java.vendor"), sys.get("java.version"));
        Properties ant = new Properties();
        propStream = Version.class.getResourceAsStream("/ant.properties");
        if (null != propStream) {
            ant.load(propStream);
        }
        System.out.printf("   Ant version:  %s\n", ant.get("ant.version"));
        Properties maven = new Properties();
        propStream = Version.class.getResourceAsStream("/maven.properties");
        if (null != propStream) {
            maven.load(propStream);
        }
        System.out.printf(" Maven version:  %s\n", maven.get("maven.version"));
        System.out.printf("   DSpace home:  %s\n", config.getProperty("dspace.dir"));
    }
}

