/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.dspace.authority.AuthoritySearchService;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.indexer.AuthorityIndexingService;
import org.dspace.core.ConfigurationManager;

public class AuthoritySolrServiceImpl
implements AuthorityIndexingService,
AuthoritySearchService {
    private static final Logger log = Logger.getLogger(AuthoritySolrServiceImpl.class);
    protected HttpSolrServer solr = null;

    protected AuthoritySolrServiceImpl() {
    }

    protected HttpSolrServer getSolr() throws MalformedURLException, SolrServerException {
        if (this.solr == null) {
            String solrService = ConfigurationManager.getProperty("solr.authority.server");
            log.debug((Object)("Solr authority URL: " + solrService));
            this.solr = new HttpSolrServer(solrService);
            this.solr.setBaseURL(solrService);
            SolrQuery solrQuery = new SolrQuery().setQuery("*:*");
            this.solr.query((SolrParams)solrQuery);
        }
        return this.solr;
    }

    @Override
    public void indexContent(AuthorityValue value) {
        SolrInputDocument doc = value.getSolrInputDocument();
        try {
            this.writeDocument(doc);
        }
        catch (Exception e) {
            log.error((Object)("Error while writing authority value to the index: " + value.toString()), (Throwable)e);
        }
    }

    @Override
    public void cleanIndex() throws Exception {
        try {
            this.getSolr().deleteByQuery("*:*");
        }
        catch (Exception e) {
            log.error((Object)"Error while cleaning authority solr server index", (Throwable)e);
            throw new Exception(e);
        }
    }

    @Override
    public void commit() {
        try {
            this.getSolr().commit();
        }
        catch (SolrServerException e) {
            log.error((Object)"Error while committing authority solr server", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error while committing authority solr server", (Throwable)e);
        }
    }

    @Override
    public boolean isConfiguredProperly() {
        boolean solrReturn = false;
        try {
            solrReturn = this.getSolr() != null;
        }
        catch (Exception e) {
            log.error((Object)"Authority solr is not correctly configured, check \"solr.authority.server\" property in the dspace.cfg", (Throwable)e);
        }
        return solrReturn;
    }

    protected void writeDocument(SolrInputDocument doc) throws IOException {
        try {
            this.getSolr().add(doc);
        }
        catch (Exception e) {
            try {
                log.error((Object)("An error occurred for document: " + doc.getField("id").getFirstValue() + ", source: " + doc.getField("source").getFirstValue() + ", field: " + doc.getField("field").getFirstValue() + ", full-text: " + doc.getField("full-text").getFirstValue()), (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public QueryResponse search(SolrQuery query) throws SolrServerException, MalformedURLException {
        return this.getSolr().query((SolrParams)query);
    }

    @Override
    public List<String> getAllIndexedMetadataFields() throws Exception {
        List values;
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery("*:*");
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{"field"});
        QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
        ArrayList<String> results = new ArrayList<String>();
        FacetField facetField = response.getFacetField("field");
        if (facetField != null && (values = facetField.getValues()) != null) {
            for (FacetField.Count facetValue : values) {
                if (facetValue == null || facetValue.getName() == null) continue;
                results.add(facetValue.getName());
            }
        }
        return results;
    }
}

