/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseDAO;
import org.dspace.browse.BrowseDAOFactory;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.sort.OrderFormat;
import org.dspace.sort.SortOption;

public class BrowseEngine {
    private static final Logger log = Logger.getLogger(BrowseEngine.class);
    private BrowserScope scope;
    private final Context context;
    private final BrowseDAO dao;
    private BrowseIndex browseIndex;

    public BrowseEngine(Context context) throws BrowseException {
        this.context = context;
        this.dao = BrowseDAOFactory.getInstance(context);
    }

    public BrowseInfo browse(BrowserScope bs) throws BrowseException {
        log.debug((Object)LogManager.getHeader(this.context, "browse", ""));
        this.scope = bs;
        this.browseIndex = this.scope.getBrowseIndex();
        if (this.browseIndex.isMetadataIndex() && !this.scope.isSecondLevel()) {
            return this.browseByValue(this.scope);
        }
        return this.browseByItem(this.scope);
    }

    public BrowseInfo browseMini(BrowserScope bs) throws BrowseException {
        log.info((Object)LogManager.getHeader(this.context, "browse_mini", ""));
        this.scope = bs;
        this.browseIndex = this.scope.getBrowseIndex();
        this.dao.setTable(this.browseIndex.getTableName());
        this.dao.setAscending(this.scope.isAscending());
        if (this.scope.inCollection() || this.scope.inCommunity()) {
            if (this.scope.inCollection()) {
                Collection col = (Collection)this.scope.getBrowseContainer();
                this.dao.setContainerTable("collection2item");
                this.dao.setContainerIDField("collection_id");
                this.dao.setContainerID(col.getID());
            } else if (this.scope.inCommunity()) {
                Community com = (Community)this.scope.getBrowseContainer();
                this.dao.setContainerTable("communities2item");
                this.dao.setContainerIDField("community_id");
                this.dao.setContainerID(com.getID());
            }
        }
        this.dao.setOffset(this.scope.getOffset());
        this.dao.setLimit(this.scope.getResultsPerPage());
        String orderBy = this.browseIndex.getSortField(this.scope.isSecondLevel());
        if (this.scope.getSortBy() > 0) {
            orderBy = "sort_" + Integer.toString(this.scope.getSortBy());
        }
        this.dao.setOrderField(orderBy);
        List<Item> results = this.dao.doQuery();
        BrowseInfo browseInfo = new BrowseInfo(results, 0, this.scope.getResultsPerPage(), 0);
        browseInfo.setBrowseIndex(this.browseIndex);
        browseInfo.setSortOption(this.scope.getSortOption());
        browseInfo.setAscending(this.scope.isAscending());
        if (this.scope.inCollection() || this.scope.inCommunity()) {
            browseInfo.setBrowseContainer(this.scope.getBrowseContainer());
        }
        browseInfo.setResultsPerPage(this.scope.getResultsPerPage());
        browseInfo.setEtAl(this.scope.getEtAl());
        return browseInfo;
    }

    private BrowseInfo browseByItem(BrowserScope bs) throws BrowseException {
        log.info((Object)LogManager.getHeader(this.context, "browse_by_item", ""));
        try {
            this.dao.setTable(this.browseIndex.getTableName());
            this.dao.setAscending(this.scope.isAscending());
            String rawValue = null;
            if (this.scope.hasFilterValue() && this.scope.isSecondLevel()) {
                String value;
                rawValue = value = this.scope.getFilterValue();
                value = OrderFormat.makeSortString(value, this.scope.getFilterValueLang(), this.scope.getBrowseIndex().getDataType());
                this.dao.setAuthorityValue(this.scope.getAuthorityValue());
                if (this.scope.isSecondLevel()) {
                    this.dao.setFilterValueField("value");
                    this.dao.setFilterValue(rawValue);
                } else {
                    this.dao.setFilterValueField("sort_value");
                    this.dao.setFilterValue(value);
                }
                this.dao.setFilterValuePartial(this.scope.getFilterValuePartial());
                this.dao.setFilterMappingTables(this.browseIndex.getDistinctTableName(), this.browseIndex.getMapTableName());
            }
            if (this.scope.inCollection() || this.scope.inCommunity()) {
                if (this.scope.inCollection()) {
                    Collection col = (Collection)this.scope.getBrowseContainer();
                    this.dao.setContainerTable("collection2item");
                    this.dao.setContainerIDField("collection_id");
                    this.dao.setContainerID(col.getID());
                } else if (this.scope.inCommunity()) {
                    Community com = (Community)this.scope.getBrowseContainer();
                    this.dao.setContainerTable("communities2item");
                    this.dao.setContainerIDField("community_id");
                    this.dao.setContainerID(com.getID());
                }
            }
            int total = this.getTotalResults();
            String orderBy = this.browseIndex.getSortField(this.scope.isSecondLevel());
            if (this.scope.getSortBy() > 0) {
                orderBy = "sort_" + Integer.toString(this.scope.getSortBy());
            }
            this.dao.setOrderField(orderBy);
            int offset = this.scope.getOffset();
            String rawFocusValue = null;
            if (offset < 1 && (this.scope.hasJumpToItem() || this.scope.hasJumpToValue() || this.scope.hasStartsWith())) {
                rawFocusValue = this.getJumpToValue();
                String focusValue = this.normalizeJumpToValue(rawFocusValue);
                log.debug((Object)("browsing using focus: " + focusValue));
                offset = this.getOffsetForValue(focusValue);
            }
            this.dao.setOffset(offset);
            this.dao.setLimit(this.scope.getResultsPerPage());
            List<Item> results = null;
            if (total > 0) {
                results = this.dao.doQuery();
                if (results.size() == 0) {
                    offset = total - this.scope.getResultsPerPage();
                    if (offset < 0) {
                        offset = 0;
                    }
                    this.dao.setOffset(offset);
                    results = this.dao.doQuery();
                }
            } else {
                results = new ArrayList<Item>();
            }
            BrowseInfo browseInfo = new BrowseInfo(results, offset, total, offset);
            if (offset + this.scope.getResultsPerPage() < total) {
                browseInfo.setNextOffset(offset + this.scope.getResultsPerPage());
            }
            if (offset - this.scope.getResultsPerPage() > -1) {
                browseInfo.setPrevOffset(offset - this.scope.getResultsPerPage());
            }
            browseInfo.setBrowseIndex(this.browseIndex);
            browseInfo.setSortOption(this.scope.getSortOption());
            browseInfo.setAscending(this.scope.isAscending());
            browseInfo.setBrowseLevel(this.scope.getBrowseLevel());
            browseInfo.setValue(rawValue);
            browseInfo.setAuthority(this.scope.getAuthorityValue());
            browseInfo.setFocus(rawFocusValue);
            if (this.scope.hasJumpToItem()) {
                browseInfo.setFocusItem(this.scope.getJumpToItem());
            }
            browseInfo.setStartsWith(this.scope.hasStartsWith());
            if (this.scope.inCollection() || this.scope.inCommunity()) {
                browseInfo.setBrowseContainer(this.scope.getBrowseContainer());
            }
            browseInfo.setResultsPerPage(this.scope.getResultsPerPage());
            browseInfo.setEtAl(this.scope.getEtAl());
            return browseInfo;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    private BrowseInfo browseByValue(BrowserScope bs) throws BrowseException {
        log.info((Object)LogManager.getHeader(this.context, "browse_by_value", "focus=" + bs.getJumpToValue()));
        try {
            this.dao.setTable(this.browseIndex.getDistinctTableName());
            this.dao.setStartsWith("0".equals(this.scope.getStartsWith()) && !this.scope.getOrder().equals("ASC") ? "9" : this.normalizeJumpToValue(this.scope.getStartsWith()));
            this.dao.setDistinct(true);
            this.dao.setAscending(this.scope.isAscending());
            this.dao.setEnableBrowseFrequencies(this.browseIndex.isDisplayFrequencies());
            if (this.browseIndex.isDisplayFrequencies()) {
                this.dao.setFilterMappingTables(null, this.browseIndex.getMapTableName());
            }
            if (this.scope.inCollection() || this.scope.inCommunity()) {
                if (!this.browseIndex.isDisplayFrequencies()) {
                    this.dao.setFilterMappingTables(null, this.browseIndex.getMapTableName());
                }
                if (this.scope.inCollection()) {
                    Collection col = (Collection)this.scope.getBrowseContainer();
                    this.dao.setContainerTable("collection2item");
                    this.dao.setContainerIDField("collection_id");
                    this.dao.setContainerID(col.getID());
                } else if (this.scope.inCommunity()) {
                    Community com = (Community)this.scope.getBrowseContainer();
                    this.dao.setContainerTable("communities2item");
                    this.dao.setContainerIDField("community_id");
                    this.dao.setContainerID(com.getID());
                }
            }
            int total = this.getTotalResults(true);
            this.dao.setOrderField("sort_value");
            this.dao.setJumpToField("sort_value");
            int offset = this.scope.getOffset();
            int limit = this.scope.getResultsPerPage();
            List<Object> results = null;
            String rawFocusValue = null;
            if (offset < 1 && this.scope.hasJumpToValue() || this.scope.hasStartsWith()) {
                rawFocusValue = this.getJumpToValue();
            }
            if ("0".equals(this.scope.getStartsWith())) {
                int currentSW = this.scope.getOrder().equals("ASC") ? 0 : 9;
                results = new ArrayList();
                while (results.size() < this.scope.getResultsPerPage() && currentSW <= 9 && currentSW >= 0) {
                    List<String[]> thisNumResults = this.dao.doValueQuery();
                    if (offset < thisNumResults.size()) {
                        if (offset + limit < thisNumResults.size()) {
                            results.addAll(thisNumResults.subList(offset, offset + limit));
                            break;
                        }
                        thisNumResults = thisNumResults.subList(offset, thisNumResults.size());
                        results.addAll(thisNumResults);
                        offset = 0;
                        limit -= thisNumResults.size();
                    } else {
                        offset -= thisNumResults.size();
                    }
                    this.dao.setStartsWith(String.valueOf(this.scope.getOrder().equals("ASC") ? ++currentSW : --currentSW));
                }
                offset = this.scope.getOffset();
            } else {
                this.dao.setOffset(offset);
                this.dao.setLimit(limit);
                if (total > 0) {
                    results = this.dao.doValueQuery();
                    if (results.size() == 0) {
                        offset = total - this.scope.getResultsPerPage();
                        if (offset < 0) {
                            offset = 0;
                        }
                        this.dao.setOffset(offset);
                        results = this.dao.doValueQuery();
                    }
                } else {
                    results = new ArrayList();
                }
            }
            BrowseInfo browseInfo = new BrowseInfo(results, offset, total, offset);
            if (offset + this.scope.getResultsPerPage() < total) {
                browseInfo.setNextOffset(offset + this.scope.getResultsPerPage());
            }
            if (offset - this.scope.getResultsPerPage() > -1) {
                browseInfo.setPrevOffset(offset - this.scope.getResultsPerPage());
            }
            browseInfo.setBrowseIndex(this.browseIndex);
            browseInfo.setSortOption(this.scope.getSortOption());
            browseInfo.setAscending(this.scope.isAscending());
            browseInfo.setBrowseLevel(this.scope.getBrowseLevel());
            browseInfo.setFocus(rawFocusValue);
            browseInfo.setStartsWith(this.scope.hasStartsWith());
            if (this.scope.inCollection() || this.scope.inCommunity()) {
                browseInfo.setBrowseContainer(this.scope.getBrowseContainer());
            }
            browseInfo.setResultsPerPage(this.scope.getResultsPerPage());
            return browseInfo;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    private String getJumpToValue() throws BrowseException {
        log.debug((Object)LogManager.getHeader(this.context, "get_focus_value", ""));
        if (this.scope.hasJumpToValue()) {
            log.debug((Object)LogManager.getHeader(this.context, "get_focus_value_return", "return=" + this.scope.getJumpToValue()));
            return this.scope.getJumpToValue();
        }
        if (this.scope.hasStartsWith()) {
            log.debug((Object)LogManager.getHeader(this.context, "get_focus_value_return", "return=" + this.scope.getStartsWith()));
            return this.scope.getStartsWith();
        }
        int id = this.scope.getJumpToItem();
        String tableName = this.browseIndex.getTableName();
        SortOption so = this.scope.getSortOption();
        if ((so == null || so.getNumber() == 0) && this.browseIndex.getSortOption() != null) {
            so = this.browseIndex.getSortOption();
        }
        String col = "sort_1";
        if (so.getNumber() > 0) {
            col = "sort_" + Integer.toString(so.getNumber());
        }
        String max = this.dao.doMaxQuery(col, tableName, id);
        log.debug((Object)LogManager.getHeader(this.context, "get_focus_value_return", "return=" + max));
        return max;
    }

    private int getOffsetForValue(String value) throws BrowseException {
        SortOption so = this.scope.getSortOption();
        if ((so == null || so.getNumber() == 0) && this.browseIndex.getSortOption() != null) {
            so = this.browseIndex.getSortOption();
        }
        String col = "sort_1";
        if (so.getNumber() > 0) {
            col = "sort_" + Integer.toString(so.getNumber());
        }
        return this.dao.doOffsetQuery(col, value, this.scope.isAscending());
    }

    private int getOffsetForDistinctValue(String value) throws BrowseException {
        if (!this.browseIndex.isMetadataIndex()) {
            throw new IllegalArgumentException("getOffsetForDistinctValue called when not a metadata index");
        }
        return this.dao.doDistinctOffsetQuery("sort_value", value, this.scope.isAscending());
    }

    private String normalizeJumpToValue(String value) throws BrowseException {
        if (this.scope.hasJumpToValue()) {
            return OrderFormat.makeSortString(this.scope.getJumpToValue(), this.scope.getJumpToValueLang(), this.scope.getBrowseIndex().getDataType());
        }
        if (this.scope.hasStartsWith()) {
            return OrderFormat.makeSortString(this.scope.getStartsWith(), null, this.scope.getBrowseIndex().getDataType());
        }
        return value;
    }

    private int getTotalResults() throws SQLException, BrowseException {
        return this.getTotalResults(false);
    }

    private int getTotalResults(boolean distinct) throws SQLException, BrowseException {
        log.debug((Object)LogManager.getHeader(this.context, "get_total_results", "distinct=" + distinct));
        this.dao.setDistinct(distinct);
        String[] select = new String[]{"*"};
        this.dao.setCountValues(select);
        String focusField = this.dao.getJumpToField();
        String focusValue = this.dao.getJumpToValue();
        String orderField = this.dao.getOrderField();
        int limit = this.dao.getLimit();
        int offset = this.dao.getOffset();
        this.dao.setJumpToField(null);
        this.dao.setJumpToValue(null);
        this.dao.setOrderField(null);
        this.dao.setLimit(-1);
        this.dao.setOffset(-1);
        int count = this.dao.doCountQuery();
        if ("0".equals(this.dao.getStartsWith())) {
            for (int x = 1; x <= 9; ++x) {
                this.dao.setStartsWith(String.valueOf(x));
                count += this.dao.doCountQuery();
            }
            this.dao.setStartsWith("0");
        } else if ("9".equals(this.dao.getStartsWith())) {
            for (int x = 8; x >= 0; --x) {
                this.dao.setStartsWith(String.valueOf(x));
                count += this.dao.doCountQuery();
            }
            this.dao.setStartsWith("9");
        }
        this.dao.setJumpToField(focusField);
        this.dao.setJumpToValue(focusValue);
        this.dao.setOrderField(orderField);
        this.dao.setLimit(limit);
        this.dao.setOffset(offset);
        this.dao.setCountValues(null);
        log.debug((Object)LogManager.getHeader(this.context, "get_total_results_return", "return=" + count));
        return count;
    }
}

