/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectLegacySupport;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.hibernate.proxy.HibernateProxyHelper;

@Entity
@Table(name="bitstream")
public class Bitstream
extends DSpaceObject
implements DSpaceObjectLegacySupport {
    @Column(name="bitstream_id", insertable=false, updatable=false)
    private Integer legacyId;
    @Column(name="sequence_id")
    private Integer sequenceId = -1;
    @Column(name="checksum", length=64)
    private String checksum;
    @Column(name="checksum_algorithm", length=32)
    private String checksumAlgorithm;
    @Column(name="size_bytes")
    private long sizeBytes;
    @Column(name="deleted")
    private boolean deleted = false;
    @Column(name="internal_id", length=256)
    private String internalId;
    @Column(name="store_number")
    private int storeNumber;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="bitstream_format_id")
    private BitstreamFormat bitstreamFormat;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="bitstreams")
    private List<Bundle> bundles = new ArrayList<Bundle>();
    @OneToOne(fetch=FetchType.LAZY, mappedBy="logo")
    private Community community;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="logo")
    private Collection collection;
    @Transient
    private transient BitstreamService bitstreamService;

    protected Bitstream() {
    }

    public int getSequenceID() {
        if (this.sequenceId == null) {
            return -1;
        }
        return this.sequenceId;
    }

    public void setSequenceID(int sid) {
        this.sequenceId = sid;
        this.setMetadataModified();
        this.addDetails("SequenceID");
    }

    @Override
    public String getName() {
        return this.getBitstreamService().getMetadataFirstValue(this, "dc", "title", null, "*");
    }

    public void setName(Context context, String n) throws SQLException {
        this.getBitstreamService().setMetadataSingleValue(context, this, "dc", "title", null, null, n);
    }

    public String getSource() {
        return this.getBitstreamService().getMetadataFirstValue(this, "dc", "source", null, "*");
    }

    public void setSource(Context context, String n) throws SQLException {
        this.getBitstreamService().setMetadataSingleValue(context, this, "dc", "source", null, null, n);
    }

    public String getDescription() {
        return this.getBitstreamService().getMetadataFirstValue(this, "dc", "description", null, "*");
    }

    public void setDescription(Context context, String n) throws SQLException {
        this.getBitstreamService().setMetadataSingleValue(context, this, "dc", "description", null, null, n);
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public void setChecksumAlgorithm(String checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm;
    }

    @Deprecated
    public long getSize() {
        return this.getSizeBytes();
    }

    public long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public String getUserFormatDescription() {
        return this.getBitstreamService().getMetadataFirstValue(this, "dc", "format", null, "*");
    }

    protected BitstreamFormat getBitstreamFormat() {
        return this.bitstreamFormat;
    }

    public BitstreamFormat getFormat(Context context) throws SQLException {
        return this.getBitstreamService().getFormat(context, this);
    }

    void setFormat(BitstreamFormat bitstreamFormat) {
        this.bitstreamFormat = bitstreamFormat;
        this.setModified();
    }

    public boolean isDeleted() throws SQLException {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public List<Bundle> getBundles() throws SQLException {
        return this.bundles;
    }

    void setBundles(List<Bundle> bundles) {
        this.bundles = bundles;
    }

    @Override
    public int getType() {
        return 0;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public Community getCommunity() {
        return this.community;
    }

    public int getStoreNumber() {
        return this.storeNumber;
    }

    public void setStoreNumber(int storeNumber) {
        this.storeNumber = storeNumber;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    public void setUserFormatDescription(Context context, String desc) throws SQLException {
        this.getBitstreamService().setUserFormatDescription(context, this, desc);
    }

    public String getFormatDescription(Context context) throws SQLException {
        return this.getBitstreamService().getFormatDescription(context, this);
    }

    public void setFormat(Context context, BitstreamFormat f) throws SQLException {
        this.getBitstreamService().setFormat(context, this, f);
    }

    @Override
    public Integer getLegacyId() {
        return this.legacyId;
    }

    private BitstreamService getBitstreamService() {
        if (this.bitstreamService == null) {
            this.bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
        }
        return this.bitstreamService;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)other);
        if (this.getClass() != objClass) {
            return false;
        }
        Bitstream otherBitstream = (Bitstream)other;
        return this.getID().equals(otherBitstream.getID());
    }

    public int hashCode() {
        int hash = 5;
        hash += 73 * hash + this.getType();
        hash += 73 * hash + this.getID().hashCode();
        return hash;
    }
}

