/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkMetadataValidator;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.jdom.Element;
import org.jdom.Namespace;

public class OAIDCIngestionCrosswalk
implements IngestionCrosswalk {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private CrosswalkMetadataValidator metadataValidator = new CrosswalkMetadataValidator();

    @Override
    public void ingest(Context context, DSpaceObject dso, List<Element> metadata, boolean createMissingMetadataFields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Element wrapper = new Element("wrap", metadata.get(0).getNamespace());
        wrapper.addContent(metadata);
        this.ingest(context, dso, wrapper, createMissingMetadataFields);
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, Element root, boolean createMissingMetadataFields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("DIMIngestionCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        if (root == null) {
            System.err.println("The element received by ingest was null");
            return;
        }
        List metadata = root.getChildren();
        for (Element element : metadata) {
            String lang = element.getAttributeValue("lang", Namespace.XML_NAMESPACE);
            if (lang == null) {
                lang = element.getAttributeValue("lang");
            }
            MetadataField metadataField = this.metadataValidator.checkMetadata(context, "dc", element.getName(), null, createMissingMetadataFields);
            this.itemService.addMetadata(context, item, metadataField, lang, element.getText());
        }
    }
}

