/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.List;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.dao.BitstreamFormatDAO;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class BitstreamFormatDAOImpl
extends AbstractHibernateDAO<BitstreamFormat>
implements BitstreamFormatDAO {
    protected BitstreamFormatDAOImpl() {
    }

    @Override
    public BitstreamFormat findByMIMEType(Context context, String mimeType, boolean includeInternal) throws SQLException {
        Criteria criteria = this.createCriteria(context, BitstreamFormat.class);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"internal", (Object)includeInternal), (Criterion)Restrictions.like((String)"mimetype", (Object)mimeType)));
        return (BitstreamFormat)this.singleResult(criteria);
    }

    @Override
    public BitstreamFormat findByShortDescription(Context context, String desc) throws SQLException {
        Criteria criteria = this.createCriteria(context, BitstreamFormat.class);
        criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"shortDescription", (Object)desc)}));
        return (BitstreamFormat)this.uniqueResult(criteria);
    }

    @Override
    public int updateRemovedBitstreamFormat(Context context, BitstreamFormat deletedBitstreamFormat, BitstreamFormat newBitstreamFormat) throws SQLException {
        Query query = this.createQuery(context, "update Bitstream set bitstreamFormat = :unknown_format where bitstreamFormat = :deleted_format");
        query.setParameter("unknown_format", (Object)newBitstreamFormat);
        query.setParameter("deleted_format", (Object)deletedBitstreamFormat);
        return query.executeUpdate();
    }

    @Override
    public List<BitstreamFormat> findNonInternal(Context context) throws SQLException {
        Criteria criteria = this.createCriteria(context, BitstreamFormat.class);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"internal", (Object)false), (Criterion)Restrictions.not((Criterion)Restrictions.like((String)"shortDescription", (Object)"Unknown"))));
        criteria.addOrder(Order.desc((String)"supportLevel")).addOrder(Order.asc((String)"shortDescription"));
        return this.list(criteria);
    }

    @Override
    public List<BitstreamFormat> findByFileExtension(Context context, String extension) throws SQLException {
        Query query = this.createQuery(context, "from BitstreamFormat bf where :extension in elements(bf.fileExtensions)");
        query.setParameter("extension", (Object)extension);
        return this.list(query);
    }

    @Override
    public List<BitstreamFormat> findAll(Context context, Class clazz) throws SQLException {
        Criteria criteria = this.createCriteria(context, BitstreamFormat.class);
        criteria.addOrder(Order.asc((String)"id"));
        return this.list(criteria);
    }
}

