/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.core.Context;
import org.dspace.core.GenericDAO;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;

public abstract class AbstractHibernateDAO<T>
implements GenericDAO<T> {
    protected AbstractHibernateDAO() {
    }

    @Override
    public T create(Context context, T t) throws SQLException {
        this.getHibernateSession(context).persist(t);
        return t;
    }

    @Override
    public void save(Context context, T t) throws SQLException {
    }

    protected Session getHibernateSession(Context context) throws SQLException {
        return (Session)context.getDBConnection().getSession();
    }

    @Override
    public void delete(Context context, T t) throws SQLException {
        this.getHibernateSession(context).delete(t);
    }

    @Override
    public List<T> findAll(Context context, Class<T> clazz) throws SQLException {
        return this.list(this.createCriteria(context, clazz));
    }

    @Override
    public T findUnique(Context context, String query) throws SQLException {
        Object result = this.createQuery(context, query).uniqueResult();
        return (T)result;
    }

    @Override
    public T findByID(Context context, Class clazz, UUID id) throws SQLException {
        if (id == null) {
            return null;
        }
        Object result = this.getHibernateSession(context).get(clazz, (Serializable)id);
        return (T)result;
    }

    @Override
    public T findByID(Context context, Class clazz, int id) throws SQLException {
        Object result = this.getHibernateSession(context).get(clazz, (Serializable)Integer.valueOf(id));
        return (T)result;
    }

    @Override
    public List<T> findMany(Context context, String query) throws SQLException {
        List result = this.createQuery(context, query).list();
        return result;
    }

    public List<T> findMany(Context context, Query query) throws SQLException {
        List result = query.list();
        return result;
    }

    public Criteria createCriteria(Context context, Class<T> persistentClass) throws SQLException {
        return this.getHibernateSession(context).createCriteria(persistentClass);
    }

    public Criteria createCriteria(Context context, Class<T> persistentClass, String alias) throws SQLException {
        return this.getHibernateSession(context).createCriteria(persistentClass, alias);
    }

    public Query createQuery(Context context, String query) throws SQLException {
        return this.getHibernateSession(context).createQuery(query);
    }

    public List<T> list(Criteria criteria) {
        List result = criteria.list();
        return result;
    }

    public List<T> list(Query query) {
        List result = query.list();
        return result;
    }

    public T uniqueResult(Criteria criteria) {
        Object result = criteria.uniqueResult();
        return (T)result;
    }

    public T uniqueResult(Query query) {
        Object result = query.uniqueResult();
        return (T)result;
    }

    public T singleResult(Criteria criteria) {
        criteria.setMaxResults(1);
        List<T> list = this.list(criteria);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public T singleResult(Query query) {
        query.setMaxResults(1);
        List<T> list = this.list(query);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public Iterator<T> iterate(Query query) {
        Iterator result = query.iterate();
        return result;
    }

    public int count(Criteria criteria) {
        return ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
    }

    public int count(Query query) {
        return ((Long)query.uniqueResult()).intValue();
    }

    public long countLong(Criteria criteria) {
        return (Long)criteria.setProjection(Projections.rowCount()).uniqueResult();
    }
}

