/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest.dao.impl;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.dspace.content.Collection;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.dao.HarvestedCollectionDAO;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class HarvestedCollectionDAOImpl
extends AbstractHibernateDAO<HarvestedCollection>
implements HarvestedCollectionDAO {
    protected HarvestedCollectionDAOImpl() {
    }

    @Override
    public HarvestedCollection findByStatusAndMinimalTypeOrderByLastHarvestedDesc(Context context, int status, int type, int limit) throws SQLException {
        Criteria criteria = this.getByStatusAndMinimalTypeCriteria(context, status, type, limit);
        criteria.addOrder(Order.desc((String)"lastHarvested"));
        return (HarvestedCollection)this.singleResult(criteria);
    }

    @Override
    public HarvestedCollection findByStatusAndMinimalTypeOrderByLastHarvestedAsc(Context context, int status, int type, int limit) throws SQLException {
        Criteria criteria = this.getByStatusAndMinimalTypeCriteria(context, status, type, limit);
        criteria.addOrder(Order.asc((String)"lastHarvested"));
        return (HarvestedCollection)this.singleResult(criteria);
    }

    @Override
    public List<HarvestedCollection> findByStatus(Context context, int status) throws SQLException {
        Criteria criteria = this.createCriteria(context, HarvestedCollection.class);
        criteria.add((Criterion)Restrictions.eq((String)"harvestStatus", (Object)status));
        return this.list(criteria);
    }

    @Override
    public HarvestedCollection findByCollection(Context context, Collection collection) throws SQLException {
        Criteria criteria = this.createCriteria(context, HarvestedCollection.class);
        criteria.add((Criterion)Restrictions.eq((String)"collection", (Object)collection));
        return (HarvestedCollection)this.singleResult(criteria);
    }

    @Override
    public List<HarvestedCollection> findByLastHarvestedAndHarvestTypeAndHarvestStatusesAndHarvestTime(Context context, Date startTime, int minimalType, int[] statuses, int expirationStatus, Date expirationTime) throws SQLException {
        Criteria criteria = this.createCriteria(context, HarvestedCollection.class);
        LogicalExpression lastHarvestedRestriction = Restrictions.or((Criterion)Restrictions.lt((String)"lastHarvested", (Object)startTime), (Criterion)Restrictions.isNull((String)"lastHarvested"));
        Disjunction statusRestriction = Restrictions.or((Criterion[])new Criterion[0]);
        for (int status : statuses) {
            statusRestriction.add((Criterion)Restrictions.eq((String)"harvestStatus", (Object)status));
        }
        statusRestriction.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"harvestStatus", (Object)expirationStatus), (Criterion)Restrictions.gt((String)"harvestStartTime", (Object)expirationTime)));
        criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{lastHarvestedRestriction, Restrictions.gt((String)"harvestType", (Object)minimalType), statusRestriction}));
        criteria.addOrder(Order.asc((String)"lastHarvested"));
        return this.list(criteria);
    }

    @Override
    public int count(Context context) throws SQLException {
        Criteria criteria = this.createCriteria(context, HarvestedCollection.class);
        return this.count(criteria);
    }

    protected Criteria getByStatusAndMinimalTypeCriteria(Context context, int status, int type, int limit) throws SQLException {
        Criteria criteria = this.createCriteria(context, HarvestedCollection.class);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.gt((String)"harvestType", (Object)type), (Criterion)Restrictions.eq((String)"harvestStatus", (Object)status)));
        if (limit != -1) {
            criteria.setMaxResults(1);
        }
        return criteria;
    }
}

