/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.identifier.service.IdentifierService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class IdentifierServiceImpl
implements IdentifierService {
    private List<IdentifierProvider> providers;
    private static Logger log = Logger.getLogger(IdentifierServiceImpl.class);
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;
    @Autowired(required=true)
    protected HandleService handleService;

    protected IdentifierServiceImpl() {
    }

    @Autowired
    @Required
    public void setProviders(List<IdentifierProvider> providers) {
        this.providers = providers;
        for (IdentifierProvider p : providers) {
            p.setParentService(this);
        }
    }

    @Override
    public void reserve(Context context, DSpaceObject dso) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            String identifier = service.mint(context, dso);
            if (StringUtils.isEmpty((String)identifier)) continue;
            service.reserve(context, dso, identifier);
        }
        this.contentServiceFactory.getDSpaceObjectService(dso).update(context, dso);
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            if (!service.supports(identifier)) continue;
            service.reserve(context, dso, identifier);
        }
        this.contentServiceFactory.getDSpaceObjectService(dso).update(context, dso);
    }

    @Override
    public void register(Context context, DSpaceObject dso) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            service.register(context, dso);
        }
        this.contentServiceFactory.getDSpaceObjectService(dso).update(context, dso);
    }

    @Override
    public void register(Context context, DSpaceObject object, String identifier) throws AuthorizeException, SQLException, IdentifierException {
        boolean registered = false;
        for (IdentifierProvider service : this.providers) {
            if (!service.supports(identifier)) continue;
            service.register(context, object, identifier);
            registered = true;
        }
        if (!registered) {
            throw new IdentifierException("Cannot register identifier: Didn't find a provider that supports this identifier.");
        }
        this.contentServiceFactory.getDSpaceObjectService(object).update(context, object);
    }

    @Override
    public String lookup(Context context, DSpaceObject dso, Class<? extends Identifier> identifier) {
        for (IdentifierProvider service : this.providers) {
            if (!service.supports(identifier)) continue;
            try {
                String result = service.lookup(context, dso);
                if (result == null) continue;
                return result;
            }
            catch (IdentifierNotFoundException ex) {
                log.info((Object)(service.getClass().getName() + " doesn't find an Identifier for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + ", " + dso.getID().toString() + "."));
                log.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (IdentifierException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public List<String> lookup(Context context, DSpaceObject dso) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (IdentifierProvider service : this.providers) {
            try {
                String result = service.lookup(context, dso);
                if (StringUtils.isEmpty((String)result)) continue;
                if (log.isDebugEnabled()) {
                    try {
                        log.debug((Object)("Got an identifier from " + service.getClass().getCanonicalName() + "."));
                    }
                    catch (NullPointerException ex) {
                        log.debug((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                identifiers.add(result);
            }
            catch (IdentifierNotFoundException ex) {
                log.info((Object)(service.getClass().getName() + " doesn't find an Identifier for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + ", " + dso.getID().toString() + "."));
                log.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (IdentifierException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        try {
            String handle = dso.getHandle();
            if (!(StringUtils.isEmpty((String)handle) || identifiers.contains(handle) || identifiers.contains("hdl:" + handle) || identifiers.contains(this.handleService.getCanonicalForm(handle)))) {
                log.info((Object)("Adding handle '" + handle + "' to the array of looked up identifiers."));
                identifiers.add(handle);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        log.debug((Object)("Found identifiers: " + ((Object)identifiers).toString()));
        return identifiers;
    }

    @Override
    public DSpaceObject resolve(Context context, String identifier) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        for (IdentifierProvider service : this.providers) {
            if (!service.supports(identifier)) continue;
            try {
                DSpaceObject result = service.resolve(context, identifier, new String[0]);
                if (result == null) continue;
                return result;
            }
            catch (IdentifierNotFoundException ex) {
                log.info((Object)(service.getClass().getName() + " cannot resolve Identifier " + identifier + ": identifier not found."));
                log.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (IdentifierException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public void delete(Context context, DSpaceObject dso) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            try {
                service.delete(context, dso);
            }
            catch (IdentifierException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void delete(Context context, DSpaceObject dso, String identifier) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            try {
                if (!service.supports(identifier)) continue;
                service.delete(context, dso, identifier);
            }
            catch (IdentifierException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

