/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier.dao.impl;

import java.sql.SQLException;
import java.util.List;
import org.dspace.content.DSpaceObject;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.identifier.DOI;
import org.dspace.identifier.dao.DOIDAO;
import org.hibernate.Criteria;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;

public class DOIDAOImpl
extends AbstractHibernateDAO<DOI>
implements DOIDAO {
    protected DOIDAOImpl() {
    }

    @Override
    public DOI findByDoi(Context context, String doi) throws SQLException {
        Criteria criteria = this.createCriteria(context, DOI.class);
        criteria.add((Criterion)Restrictions.eq((String)"doi", (Object)doi));
        return (DOI)this.uniqueResult(criteria);
    }

    @Override
    public DOI findDOIByDSpaceObject(Context context, DSpaceObject dso, List<Integer> statusToExclude) throws SQLException {
        Criteria criteria = this.createCriteria(context, DOI.class);
        Disjunction statusQuery = Restrictions.or((Criterion[])new Criterion[0]);
        Conjunction statusConjunctionAnd = Restrictions.and((Criterion[])new Criterion[0]);
        for (Integer status : statusToExclude) {
            statusConjunctionAnd.add(Restrictions.not((Criterion)Restrictions.eq((String)"status", (Object)status)));
        }
        statusQuery.add((Criterion)statusConjunctionAnd);
        statusQuery.add(Restrictions.isNull((String)"status"));
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"dSpaceObject", (Object)dso), (Criterion)statusQuery));
        return (DOI)this.singleResult(criteria);
    }

    @Override
    public List<DOI> findByStatus(Context context, List<Integer> statuses) throws SQLException {
        Criteria criteria = this.createCriteria(context, DOI.class);
        Disjunction statusQuery = Restrictions.or((Criterion[])new Criterion[0]);
        for (Integer status : statuses) {
            statusQuery.add((Criterion)Restrictions.eq((String)"status", (Object)status));
        }
        criteria.add((Criterion)statusQuery);
        return this.list(criteria);
    }

    @Override
    public List<DOI> findSimilarNotInState(Context context, String doi, List<Integer> excludedStatuses, boolean dsoNotNull) throws SQLException {
        Criteria criteria = this.createCriteria(context, DOI.class);
        Conjunction conjunctionAnd = Restrictions.and((Criterion[])new Criterion[0]);
        Disjunction statusQuery = Restrictions.or((Criterion[])new Criterion[0]);
        for (Integer status : excludedStatuses) {
            statusQuery.add((Criterion)Restrictions.ne((String)"status", (Object)status));
        }
        conjunctionAnd.add((Criterion)Restrictions.like((String)"doi", (Object)doi));
        conjunctionAnd.add((Criterion)statusQuery);
        if (dsoNotNull) {
            conjunctionAnd.add(Restrictions.isNotNull((String)"dSpaceObject"));
        }
        criteria.add((Criterion)conjunctionAnd);
        return this.list(criteria);
    }

    @Override
    public DOI findDOIByDSpaceObject(Context context, DSpaceObject dso) throws SQLException {
        Criteria criteria = this.createCriteria(context, DOI.class);
        criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"dSpaceObject", (Object)dso)}));
        return (DOI)this.singleResult(criteria);
    }
}

