/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.storage;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.atlas.web.auth.SimpleAuthenticator;
import org.apache.jena.web.DatasetGraphAccessor;
import org.apache.jena.web.DatasetGraphAccessorHTTP;
import org.apache.log4j.Logger;
import org.dspace.rdf.storage.RDFStorage;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class RDFStorageImpl
implements RDFStorage {
    private static final Logger log = Logger.getLogger(RDFStorageImpl.class);
    @Autowired(required=true)
    protected ConfigurationService configurationService;

    @Override
    public void store(String uri, Model model) {
        Node graphNode = NodeFactory.createURI((String)uri);
        DatasetGraphAccessor accessor = this.getAccessor();
        Dataset ds = DatasetFactory.create((Model)model);
        DatasetGraph dsg = ds.asDatasetGraph();
        Graph g = dsg.getDefaultGraph();
        accessor.httpPut(graphNode, g);
    }

    @Override
    public Model load(String uri) {
        Node graphNode = NodeFactory.createURI((String)uri);
        DatasetGraphAccessor accessor = this.getAccessor();
        Graph g = accessor.httpGet(graphNode);
        if (g == null || g.isEmpty()) {
            return null;
        }
        GraphStore gs = GraphStoreFactory.create((Graph)g);
        Dataset ds = gs.toDataset();
        Model m = ds.getDefaultModel();
        return m;
    }

    protected DatasetGraphAccessor getAccessor() {
        DatasetGraphAccessorHTTP accessor;
        if (this.configurationService.hasProperty("rdf.storage.graphstore.login") && this.configurationService.hasProperty("rdf.storage.graphstore.password")) {
            SimpleAuthenticator httpAuthenticator = new SimpleAuthenticator(this.configurationService.getProperty("rdf.storage.graphstore.login"), this.configurationService.getProperty("rdf.storage.graphstore.password").toCharArray());
            accessor = new DatasetGraphAccessorHTTP(this.getGraphStoreEndpoint(), (HttpAuthenticator)httpAuthenticator);
        } else {
            log.debug((Object)"Did not found credential to use for our connection to the Graph Store HTTP endpoint, trying to connect unauthenticated.");
            accessor = new DatasetGraphAccessorHTTP(this.getGraphStoreEndpoint());
        }
        return accessor;
    }

    @Override
    public void delete(String uri) {
        this.getAccessor().httpDelete(NodeFactory.createURI((String)uri));
    }

    @Override
    public void deleteAll() {
        for (String graph : this.getAllStoredGraphs()) {
            this.delete(graph);
        }
        this.getAccessor().httpDelete();
    }

    @Override
    public List<String> getAllStoredGraphs() {
        QueryExecution qexec;
        String queryString = "SELECT DISTINCT ?g WHERE { GRAPH ?g { ?s ?p ?o } }";
        if (this.configurationService.hasProperty("rdf.storage.sparql.login") && this.configurationService.hasProperty("rdf.storage.sparql.password")) {
            SimpleAuthenticator httpAuthenticator = new SimpleAuthenticator(this.configurationService.getProperty("rdf.storage.sparql.login"), this.configurationService.getProperty("rdf.storage.graphstore.password").toCharArray());
            qexec = QueryExecutionFactory.sparqlService((String)this.getSparqlEndpoint(), (String)queryString, (HttpAuthenticator)httpAuthenticator);
        } else {
            qexec = QueryExecutionFactory.sparqlService((String)this.getSparqlEndpoint(), (String)queryString);
        }
        ResultSet rs = qexec.execSelect();
        List<String> graphs = Collections.synchronizedList(new ArrayList());
        while (rs.hasNext()) {
            QuerySolution solution = rs.next();
            if (!solution.contains("g")) continue;
            graphs.add(solution.get("g").asResource().getURI());
        }
        qexec.close();
        return graphs;
    }

    protected String getGraphStoreEndpoint() {
        String endpoint = this.configurationService.getProperty("rdf.storage.graphstore.endpoint");
        if (StringUtils.isEmpty((String)endpoint)) {
            log.warn((Object)"Cannot load Graph Store HTTP Protocol endpoint! Property rdf.storage.graphstore.endpoint does not exist or is empty.");
            throw new RuntimeException("Cannot load Graph Store HTTP Protocol endpoint! Property rdf.storage.graphstore.endpoint does not exist or is empty.");
        }
        return endpoint;
    }

    protected String getSparqlEndpoint() {
        String endpoint = this.configurationService.getProperty("rdf.storage.sparql.endpoint");
        if (StringUtils.isEmpty((String)endpoint)) {
            endpoint = this.configurationService.getProperty("rdf.public.sparql.endpoint");
        }
        if (StringUtils.isEmpty((String)endpoint)) {
            log.warn((Object)"Cannot load internal or public SPARQL endpoint!");
            throw new RuntimeException("Cannot load internal or public SPARQL endpoint!");
        }
        return endpoint;
    }
}

