/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import org.apache.log4j.Logger;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.eperson.EPerson;
import org.dspace.services.model.Event;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.usage.AbstractUsageEventListener;
import org.dspace.usage.UsageEvent;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticSearchLoggerEventListener
extends AbstractUsageEventListener {
    private static Logger log = Logger.getLogger(ElasticSearchLoggerEventListener.class);
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;

    public void receiveEvent(Event event) {
        if (event instanceof UsageEvent && ((UsageEvent)event).getAction() == UsageEvent.Action.VIEW) {
            try {
                UsageEvent ue = (UsageEvent)event;
                EPerson currentUser = ue.getContext() == null ? null : ue.getContext().getCurrentUser();
                StatisticsServiceFactory.getInstance().getElasticSearchLoggerService().post(ue.getObject(), ue.getRequest(), currentUser);
                log.info((Object)("Successfully logged " + this.contentServiceFactory.getDSpaceObjectService(ue.getObject()).getTypeText(ue.getObject()) + "_" + ue.getObject().getID() + " " + ue.getObject().getName()));
            }
            catch (Exception e) {
                log.error((Object)("General Exception: " + e.getMessage()));
            }
        }
    }
}

