/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms.migration;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.dspace.storage.rdbms.migration.MigrationUtils;
import org.flywaydb.core.api.migration.MigrationChecksumProvider;
import org.flywaydb.core.api.migration.jdbc.JdbcMigration;

public class V6_0_2016_01_26__DS_2188_Remove_DBMS_Browse_Tables
implements JdbcMigration,
MigrationChecksumProvider {
    private static final Logger log = Logger.getLogger(V6_0_2016_01_26__DS_2188_Remove_DBMS_Browse_Tables.class);
    private int checksum = -1;

    public void migrate(Connection connection) throws Exception, SQLException {
        this.removeDBMSBrowseTables(connection);
    }

    private void removeDBMSBrowseTables(Connection connection) throws BrowseException {
        int i = 1;
        int countTablesNotFound = 0;
        while (countTablesNotFound < 3) {
            String tableName = BrowseIndex.getTableName(i, false, false, false, false);
            String distinctTableName = BrowseIndex.getTableName(i, false, false, true, false);
            String distinctMapName = BrowseIndex.getTableName(i, false, false, false, true);
            String sequence = BrowseIndex.getSequenceName(i, false, false);
            String mapSequence = BrowseIndex.getSequenceName(i, false, true);
            String distinctSequence = BrowseIndex.getSequenceName(i, true, false);
            String colViewName = BrowseIndex.getTableName(i, false, true, false, false);
            String comViewName = BrowseIndex.getTableName(i, true, false, false, false);
            String distinctColViewName = BrowseIndex.getTableName(i, false, true, false, true);
            String distinctComViewName = BrowseIndex.getTableName(i, true, false, false, true);
            if (DatabaseUtils.tableExists(connection, tableName, false)) {
                this.dropTable(connection, tableName);
                this.dropSequence(connection, sequence);
                this.dropView(connection, colViewName);
                this.dropView(connection, comViewName);
            }
            if (DatabaseUtils.tableExists(connection, distinctTableName, false)) {
                this.dropTable(connection, distinctTableName);
                this.dropTable(connection, distinctMapName);
                this.dropSequence(connection, distinctSequence);
                this.dropSequence(connection, mapSequence);
                this.dropView(connection, distinctColViewName);
                this.dropView(connection, distinctComViewName);
            } else {
                ++countTablesNotFound;
            }
            ++i;
        }
        this.dropItemTables(connection, BrowseIndex.getItemBrowseIndex());
        this.dropItemTables(connection, BrowseIndex.getWithdrawnBrowseIndex());
        this.dropItemTables(connection, BrowseIndex.getPrivateBrowseIndex());
        if (DatabaseUtils.tableExists(connection, "communities2item", false)) {
            this.dropTable(connection, "communities2item");
            this.dropSequence(connection, "communities2item_seq");
        }
        if (DatabaseUtils.tableExists(connection, "community_item_count", false)) {
            this.dropTable(connection, "community_item_count");
        }
        if (DatabaseUtils.tableExists(connection, "collection_item_count", false)) {
            this.dropTable(connection, "collection_item_count");
        }
    }

    private void dropTable(Connection connection, String tableName) {
        try {
            this.checksum += MigrationUtils.dropDBTable(connection, tableName).intValue();
        }
        catch (SQLException sqe) {
            log.warn((Object)("Database Table '" + tableName + " could not be dropped during migration. This warning may be ignored, if this table was already deleted."), (Throwable)sqe);
        }
    }

    private void dropSequence(Connection connection, String sequenceName) {
        try {
            this.checksum += MigrationUtils.dropDBSequence(connection, sequenceName).intValue();
        }
        catch (SQLException sqe) {
            log.warn((Object)("Database Sequence '" + sequenceName + " could not be dropped during migration. This warning may be ignored, if this sequence was already deleted."), (Throwable)sqe);
        }
    }

    private void dropView(Connection connection, String viewName) {
        try {
            this.checksum += MigrationUtils.dropDBView(connection, viewName).intValue();
        }
        catch (SQLException sqe) {
            log.warn((Object)("Database View '" + viewName + " could not be dropped during migration. This warning may be ignored, if this view was already deleted."), (Throwable)sqe);
        }
    }

    private void dropItemTables(Connection connection, BrowseIndex bix) throws BrowseException {
        if (DatabaseUtils.tableExists(connection, bix.getTableName())) {
            String tableName = bix.getTableName();
            String sequence = bix.getSequenceName(false, false);
            this.dropTable(connection, tableName);
            this.dropSequence(connection, sequence);
            String colViewName = bix.getTableName(false, true, false, false);
            String comViewName = bix.getTableName(true, false, false, false);
            this.dropView(connection, colViewName);
            this.dropView(connection, comViewName);
        }
    }

    public Integer getChecksum() {
        return this.checksum;
    }
}

