/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpException;
import org.dspace.core.Context;
import org.dspace.submit.lookup.CiNiiService;
import org.dspace.submit.lookup.NetworkSubmissionLookupDataLoader;

public class CiNiiOnlineDataLoader
extends NetworkSubmissionLookupDataLoader {
    protected CiNiiService ciniiService = new CiNiiService();
    protected boolean searchProvider = true;
    protected String appId = null;
    protected int maxResults = 10;

    public void setCiNiiService(CiNiiService ciniiService) {
        this.ciniiService = ciniiService;
    }

    @Override
    public List<String> getSupportedIdentifiers() {
        return Arrays.asList("cinii");
    }

    public void setSearchProvider(boolean searchProvider) {
        this.searchProvider = searchProvider;
    }

    @Override
    public boolean isSearchProvider() {
        return this.searchProvider;
    }

    @Override
    public List<Record> getByIdentifier(Context context, Map<String, Set<String>> keys) throws HttpException, IOException {
        Set<String> ciniiids;
        if (this.appId == null) {
            throw new RuntimeException("No CiNii Application ID is specified!");
        }
        ArrayList<Record> results = new ArrayList<Record>();
        if (keys != null && (ciniiids = keys.get("cinii")) != null && ciniiids.size() > 0) {
            for (String ciniiid : ciniiids) {
                Record record = this.ciniiService.getByCiNiiID(ciniiid, this.getAppId());
                if (record == null) continue;
                results.add(this.convertFields(record));
            }
        }
        return results;
    }

    @Override
    public List<Record> search(Context context, String title, String author, int year) throws HttpException, IOException {
        if (this.appId == null) {
            throw new RuntimeException("No CiNii Application ID is specified!");
        }
        return this.ciniiService.searchByTerm(title, author, year, this.getMaxResults(), this.getAppId());
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }
}

