/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import gr.ekt.bte.core.Record;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.dspace.app.util.XMLUtils;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.submit.lookup.CrossRefUtils;
import org.dspace.submit.lookup.SubmissionLookupUtils;
import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CrossRefService {
    private static final Logger log = Logger.getLogger(CrossRefService.class);
    protected int timeout = 1000;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Record> search(Context context, Set<String> dois, String apiKey) throws HttpException, IOException, JDOMException, ParserConfigurationException, SAXException {
        ArrayList<Record> results = new ArrayList<Record>();
        if (dois != null && dois.size() > 0) {
            for (String record : dois) {
                try {
                    HttpGet method = null;
                    try {
                        DefaultHttpClient client = new DefaultHttpClient();
                        client.getParams().setIntParameter("http.connection.timeout", this.timeout);
                        try {
                            URIBuilder uriBuilder = new URIBuilder("http://www.crossref.org/openurl/");
                            uriBuilder.addParameter("pid", apiKey);
                            uriBuilder.addParameter("noredirect", "true");
                            uriBuilder.addParameter("id", record);
                            method = new HttpGet(uriBuilder.build());
                        }
                        catch (URISyntaxException ex) {
                            throw new HttpException("Request not sent", (Throwable)ex);
                        }
                        HttpResponse response = client.execute((HttpUriRequest)method);
                        StatusLine statusLine = response.getStatusLine();
                        int statusCode = statusLine.getStatusCode();
                        if (statusCode != 200) {
                            throw new RuntimeException("Http call failed: " + statusLine);
                        }
                        try {
                            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                            factory.setValidating(false);
                            factory.setIgnoringComments(true);
                            factory.setIgnoringElementContentWhitespace(true);
                            DocumentBuilder db = factory.newDocumentBuilder();
                            Document inDoc = db.parse(response.getEntity().getContent());
                            Element xmlRoot = inDoc.getDocumentElement();
                            Element queryResult = XMLUtils.getSingleElement(xmlRoot, "query_result");
                            Element body = XMLUtils.getSingleElement(queryResult, "body");
                            Element dataRoot = XMLUtils.getSingleElement(body, "query");
                            Record crossitem = CrossRefUtils.convertCrossRefDomToRecord(dataRoot);
                            results.add(crossitem);
                        }
                        catch (Exception e) {
                            log.warn((Object)LogManager.getHeader(context, "retrieveRecordDOI", record + " DOI is not valid or not exist: " + e.getMessage()));
                        }
                    }
                    finally {
                        if (method == null) continue;
                        method.releaseConnection();
                    }
                }
                catch (RuntimeException rt) {
                    log.error((Object)rt.getMessage(), (Throwable)rt);
                }
            }
        }
        return results;
    }

    public List<Record> search(Context context, String title, String authors, int year, int count, String apiKey) throws IOException, HttpException {
        HttpGet method = null;
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            client.getParams().setIntParameter("http.connection.timeout", this.timeout);
            URIBuilder uriBuilder = new URIBuilder("http://search.labs.crossref.org/dois");
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotBlank((String)title)) {
                sb.append(title);
            }
            sb.append(" ");
            if (StringUtils.isNotBlank((String)authors)) {
                sb.append(authors);
            }
            String q = sb.toString().trim();
            uriBuilder.addParameter("q", q);
            uriBuilder.addParameter("year", year != -1 ? String.valueOf(year) : "");
            uriBuilder.addParameter("rows", count != -1 ? String.valueOf(count) : "");
            method = new HttpGet(uriBuilder.build());
            HttpResponse response = client.execute((HttpUriRequest)method);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode != 200) {
                throw new RuntimeException("Http call failed:: " + statusLine);
            }
            Gson gson = new Gson();
            Type listType = new TypeToken<ArrayList<Map>>(){}.getType();
            List json = (List)gson.fromJson(IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), listType);
            HashSet<String> dois = new HashSet<String>();
            for (Map r : json) {
                dois.add(SubmissionLookupUtils.normalizeDOI((String)r.get("doi")));
            }
            method.releaseConnection();
            List<Record> list = this.search(context, dois, apiKey);
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }
}

