/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.submit.AbstractProcessingStep;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;

public class CompleteStep
extends AbstractProcessingStep {
    private static Logger log = Logger.getLogger(CompleteStep.class);

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader(context, "submission_complete", "Completed submission with id=" + subInfo.getSubmissionItem().getID()));
        WorkflowService workflowService = WorkflowServiceFactory.getInstance().getWorkflowService();
        boolean success = false;
        try {
            workflowService.start(context, (WorkspaceItem)subInfo.getSubmissionItem());
            success = true;
        }
        catch (Exception e) {
            log.error((Object)"Caught exception in submission step: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (success) {
                context.commit();
            }
        }
        return 0;
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }
}

