/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DCPersonName;
import org.dspace.content.DCSeriesNumber;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.factory.ContentAuthorityServiceFactory;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.submit.AbstractProcessingStep;

public class DescribeStep
extends AbstractProcessingStep {
    private static Logger log = Logger.getLogger(DescribeStep.class);
    private static DCInputsReader inputsReader = null;
    public static final int STATUS_MORE_INPUT_REQUESTED = 1;
    public static final int STATUS_MISSING_REQUIRED_FIELDS = 2;
    public static final String LANGUAGE_QUALIFIER = DescribeStep.getDefaultLanguageQualifier();
    protected final ChoiceAuthorityService choiceAuthorityService;
    protected final MetadataAuthorityService metadataAuthorityService;

    public DescribeStep() throws ServletException {
        DescribeStep.getInputsReader();
        this.metadataAuthorityService = ContentAuthorityServiceFactory.getInstance().getMetadataAuthorityService();
        this.choiceAuthorityService = ContentAuthorityServiceFactory.getInstance().getChoiceAuthorityService();
    }

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String qualifier;
        int j;
        if (!request.getParameterNames().hasMoreElements()) {
            return 1;
        }
        String buttonPressed = Util.getSubmitButton(request, "submit_next");
        Item item = subInfo.getSubmissionItem().getItem();
        int currentPage = DescribeStep.getCurrentPage(request);
        Collection c = subInfo.getSubmissionItem().getCollection();
        DCInput[] inputs = null;
        try {
            inputs = inputsReader.getInputs(c.getHandle()).getPageRows(currentPage - 1, subInfo.getSubmissionItem().hasMultipleTitles(), subInfo.getSubmissionItem().isPublishedBefore());
        }
        catch (DCInputsReaderException e) {
            throw new ServletException((Throwable)e);
        }
        String documentType = "";
        if (this.itemService.getMetadataByMetadataString(item, "dc.type") != null && this.itemService.getMetadataByMetadataString(item, "dc.type").size() > 0) {
            documentType = this.itemService.getMetadataByMetadataString(item, "dc.type").get(0).getValue();
        }
        for (int i = 0; i < inputs.length; ++i) {
            if (!inputs[i].isVisible(subInfo.isInWorkflow() ? "workflow" : "submit")) continue;
            if (inputs[i].getInputType().equals("qualdrop_value")) {
                List pairs = inputs[i].getPairs();
                for (j = 0; j < pairs.size(); j += 2) {
                    String qualifier2 = (String)pairs.get(j + 1);
                    this.itemService.clearMetadata(context, item, inputs[i].getSchema(), inputs[i].getElement(), qualifier2, "*");
                }
                continue;
            }
            String qualifier3 = inputs[i].getQualifier();
            this.itemService.clearMetadata(context, item, inputs[i].getSchema(), inputs[i].getElement(), qualifier3, "*");
        }
        DescribeStep.clearErrorFields(request);
        boolean moreInput = false;
        for (j = 0; j < inputs.length; ++j) {
            if (!inputs[j].isAllowedFor(documentType) || !inputs[j].isVisible(subInfo.isInWorkflow() ? "workflow" : "submit")) continue;
            String element = inputs[j].getElement();
            qualifier = inputs[j].getQualifier();
            String schema = inputs[j].getSchema();
            String fieldName = qualifier != null && !qualifier.equals("*") ? schema + "_" + element + '_' + qualifier : schema + "_" + element;
            String fieldKey = this.metadataAuthorityService.makeFieldKey(schema, element, qualifier);
            String inputType = inputs[j].getInputType();
            if (inputType.equals("name")) {
                this.readNames(context, request, item, schema, element, qualifier, inputs[j].getRepeatable());
            } else if (inputType.equals("date")) {
                this.readDate(context, request, item, schema, element, qualifier);
            } else if (inputType.equals("dropdown") || inputType.equals("list") || this.choiceAuthorityService.isChoicesConfigured(fieldKey) && "select".equals(this.choiceAuthorityService.getPresentation(fieldKey))) {
                String[] vals = request.getParameterValues(fieldName);
                if (vals != null) {
                    for (int z = 0; z < vals.length; ++z) {
                        if (vals[z].equals("")) continue;
                        this.itemService.addMetadata(context, item, schema, element, qualifier, LANGUAGE_QUALIFIER, vals[z]);
                    }
                }
            } else if (inputType.equals("series")) {
                this.readSeriesNumbers(context, request, item, schema, element, qualifier, inputs[j].getRepeatable());
            } else if (inputType.equals("qualdrop_value")) {
                List<String> quals = this.getRepeatedParameter(request, schema + "_" + element, schema + "_" + element + "_qualifier");
                List<String> vals = this.getRepeatedParameter(request, schema + "_" + element, schema + "_" + element + "_value");
                for (int z = 0; z < vals.size(); ++z) {
                    String thisQual = quals.get(z);
                    if ("".equals(thisQual)) {
                        thisQual = null;
                    }
                    String thisVal = vals.get(z);
                    if (buttonPressed.equals("submit_" + schema + "_" + element + "_remove_" + z) || thisVal.equals("")) continue;
                    this.itemService.addMetadata(context, item, schema, element, thisQual, null, thisVal);
                }
            } else if (inputType.equals("onebox") || inputType.equals("twobox") || inputType.equals("textarea")) {
                this.readText(context, request, item, schema, element, qualifier, inputs[j].getRepeatable(), LANGUAGE_QUALIFIER, inputs[j].getLanguage());
            } else {
                throw new ServletException("Field " + fieldName + " has an unknown input type: " + inputType);
            }
            if (!moreInput && buttonPressed.equals("submit_" + fieldName + "_add")) {
                subInfo.setMoreBoxesFor(fieldName);
                subInfo.setJumpToField(fieldName);
                moreInput = true;
                continue;
            }
            if (!buttonPressed.equals("submit_" + fieldName + "_delete")) continue;
            subInfo.setJumpToField(fieldName);
        }
        if (buttonPressed.equals("submit_next") || buttonPressed.startsWith("submit_jump_") || buttonPressed.equals("submit_prev") || buttonPressed.equals("submit_cancel")) {
            for (int i = 0; i < inputs.length; ++i) {
                String scope;
                String string = scope = subInfo.isInWorkflow() ? "workflow" : "submit";
                if (!inputs[i].isVisible(scope) || !inputs[i].isAllowedFor(documentType)) continue;
                qualifier = inputs[i].getQualifier();
                if (qualifier == null && inputs[i].getInputType().equals("qualdrop_value")) {
                    qualifier = "*";
                }
                List<MetadataValue> values = this.itemService.getMetadata(item, inputs[i].getSchema(), inputs[i].getElement(), qualifier, "*");
                if (!inputs[i].isRequired() || values.size() != 0 || !inputs[i].isVisible(subInfo.isInWorkflow() ? "workflow" : "submit")) continue;
                DescribeStep.addErrorField(request, DescribeStep.getFieldName(inputs[i]));
            }
        }
        ContentServiceFactory.getInstance().getInProgressSubmissionService(subInfo.getSubmissionItem()).update(context, subInfo.getSubmissionItem());
        context.dispatchEvents();
        if (moreInput) {
            return 1;
        }
        if (DescribeStep.getErrorFields(request) != null && DescribeStep.getErrorFields(request).size() > 0) {
            return 2;
        }
        return 0;
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        String collectionHandle = "default";
        if (subInfo.getSubmissionItem() != null) {
            collectionHandle = subInfo.getSubmissionItem().getCollection().getHandle();
        }
        try {
            return DescribeStep.getInputsReader().getNumberInputPages(collectionHandle);
        }
        catch (DCInputsReaderException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static DCInputsReader getInputsReader() throws ServletException {
        if (inputsReader == null) {
            try {
                inputsReader = new DCInputsReader();
            }
            catch (DCInputsReaderException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return inputsReader;
    }

    public static DCInputsReader getInputsReader(String filename) throws ServletException {
        try {
            inputsReader = new DCInputsReader(filename);
        }
        catch (DCInputsReaderException e) {
            throw new ServletException((Throwable)e);
        }
        return inputsReader;
    }

    public static String getDefaultLanguageQualifier() {
        String language = "";
        language = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("default.language");
        if (StringUtils.isEmpty((String)language)) {
            language = "en";
        }
        return language;
    }

    protected void readNames(Context context, HttpServletRequest request, Item item, String schema, String element, String qualifier, boolean repeated) throws SQLException {
        String metadataField = this.metadataFieldService.findByElement(context, schema, element, qualifier).toString();
        String fieldKey = this.metadataAuthorityService.makeFieldKey(schema, element, qualifier);
        boolean isAuthorityControlled = this.metadataAuthorityService.isAuthorityControlled(fieldKey);
        List<Object> firsts = new LinkedList();
        List<Object> lasts = new LinkedList();
        List<Object> auths = new LinkedList();
        List<Object> confs = new LinkedList();
        if (repeated) {
            String removeButton;
            String buttonPressed;
            firsts = this.getRepeatedParameter(request, metadataField, metadataField + "_first");
            lasts = this.getRepeatedParameter(request, metadataField, metadataField + "_last");
            if (isAuthorityControlled) {
                auths = this.getRepeatedParameter(request, metadataField, metadataField + "_authority");
                confs = this.getRepeatedParameter(request, metadataField, metadataField + "_confidence");
            }
            if ((buttonPressed = Util.getSubmitButton(request, "")).startsWith(removeButton = "submit_" + metadataField + "_remove_")) {
                int valToRemove = Integer.parseInt(buttonPressed.substring(removeButton.length()));
                firsts.remove(valToRemove);
                lasts.remove(valToRemove);
                if (isAuthorityControlled && valToRemove < auths.size()) {
                    auths.remove(valToRemove);
                    confs.remove(valToRemove);
                }
            }
        } else {
            String lastName = request.getParameter(metadataField + "_last");
            String firstNames = request.getParameter(metadataField + "_first");
            String authority = request.getParameter(metadataField + "_authority");
            String confidence = request.getParameter(metadataField + "_confidence");
            if (lastName != null) {
                lasts.add(lastName);
            }
            if (firstNames != null) {
                firsts.add(firstNames);
            }
            auths.add(authority == null ? "" : authority);
            confs.add(confidence == null ? "" : confidence);
        }
        for (int i = 0; i < lasts.size(); ++i) {
            int comma;
            String f = (String)firsts.get(i);
            String l = (String)lasts.get(i);
            if (l == null || l.trim().equals("")) continue;
            if (f == null) {
                f = "";
            }
            if ((comma = l.indexOf(44)) >= 0) {
                f = f + l.substring(comma + 1);
                l = l.substring(0, comma);
                while (f.startsWith(" ")) {
                    f = f.substring(1);
                }
            }
            if (isAuthorityControlled) {
                String sconf;
                String authKey = auths.size() > i ? (String)auths.get(i) : null;
                String string = sconf = authKey != null && confs.size() > i ? (String)confs.get(i) : null;
                if (this.metadataAuthorityService.isAuthorityRequired(fieldKey) && (authKey == null || authKey.length() == 0)) {
                    log.warn((Object)("Skipping value of " + metadataField + " because the required Authority key is missing or empty."));
                    DescribeStep.addErrorField(request, metadataField);
                    continue;
                }
                this.itemService.addMetadata(context, item, schema, element, qualifier, null, new DCPersonName(l, f).toString(), authKey, sconf != null && sconf.length() > 0 ? Choices.getConfidenceValue(sconf) : 600);
                continue;
            }
            this.itemService.addMetadata(context, item, schema, element, qualifier, null, new DCPersonName(l, f).toString());
        }
    }

    protected void readText(Context context, HttpServletRequest request, Item item, String schema, String element, String qualifier, boolean repeated, String lang, boolean hasLanguageTag) throws SQLException {
        String metadataField = this.metadataFieldService.findByElement(context, schema, element, qualifier).toString();
        String fieldKey = this.metadataAuthorityService.makeFieldKey(schema, element, qualifier);
        boolean isAuthorityControlled = this.metadataAuthorityService.isAuthorityControlled(fieldKey);
        TreeMap<Object, Object> vals = null;
        List<Object> auths = null;
        List<Object> confs = null;
        if (repeated) {
            String removeButton;
            String buttonPressed;
            vals = this.getRepeatedParameterWithTheirIndices(request, metadataField, metadataField);
            if (isAuthorityControlled) {
                auths = this.getRepeatedParameter(request, metadataField, metadataField + "_authority");
                confs = this.getRepeatedParameter(request, metadataField, metadataField + "_confidence");
            }
            if ((buttonPressed = Util.getSubmitButton(request, "")).startsWith(removeButton = "submit_" + metadataField + "_remove_")) {
                int valToRemove = Integer.parseInt(buttonPressed.substring(removeButton.length()));
                int key = vals.keySet().toArray(new Integer[vals.size()])[valToRemove];
                vals.remove(key);
                if (isAuthorityControlled) {
                    auths.remove(valToRemove);
                    confs.remove(valToRemove);
                }
            }
        } else {
            vals = new TreeMap();
            String value = request.getParameter(metadataField);
            if (value != null) {
                vals.put(0, value.trim());
            }
            if (isAuthorityControlled) {
                auths = new LinkedList();
                confs = new LinkedList();
                String av = request.getParameter(metadataField + "_authority");
                String cv = request.getParameter(metadataField + "_confidence");
                auths.add(av == null ? "" : av.trim());
                confs.add(cv == null ? "" : cv.trim());
            }
        }
        int i = 0;
        for (Map.Entry<Object, Object> entry : vals.entrySet()) {
            String s = (String)entry.getValue();
            int key = (Integer)entry.getKey();
            if (s != null && !s.equals("")) {
                if (hasLanguageTag && !repeated && key == 0) {
                    lang = request.getParameter(metadataField + "[lang]");
                } else if (hasLanguageTag && repeated) {
                    lang = request.getParameter(metadataField + "_" + key + "[lang]");
                }
                if (isAuthorityControlled) {
                    String sconf;
                    String authKey = auths.size() > i ? (String)auths.get(i) : null;
                    String string = sconf = authKey != null && confs.size() > i ? (String)confs.get(i) : null;
                    if (this.metadataAuthorityService.isAuthorityRequired(fieldKey) && (authKey == null || authKey.length() == 0)) {
                        log.warn((Object)("Skipping value of " + metadataField + " because the required Authority key is missing or empty."));
                        DescribeStep.addErrorField(request, metadataField);
                    } else {
                        this.itemService.addMetadata(context, item, schema, element, qualifier, lang, s, authKey, sconf != null && sconf.length() > 0 ? Choices.getConfidenceValue(sconf) : 600);
                    }
                } else {
                    this.itemService.addMetadata(context, item, schema, element, qualifier, lang, s);
                }
            }
            ++i;
        }
    }

    protected void readDate(Context context, HttpServletRequest request, Item item, String schema, String element, String qualifier) throws SQLException {
        String metadataField = this.metadataFieldService.findByElement(context, schema, element, qualifier).toString();
        int year = Util.getIntParameter(request, metadataField + "_year");
        int month = Util.getIntParameter(request, metadataField + "_month");
        int day = Util.getIntParameter(request, metadataField + "_day");
        DCDate d = new DCDate(year, month, day, -1, -1, -1);
        if (year > 0) {
            this.itemService.addMetadata(context, item, schema, element, qualifier, null, d.toString());
        }
    }

    protected void readSeriesNumbers(Context context, HttpServletRequest request, Item item, String schema, String element, String qualifier, boolean repeated) throws SQLException {
        String metadataField = this.metadataFieldService.findByElement(context, schema, element, qualifier).toString();
        List<Object> series = new LinkedList();
        List<Object> numbers = new LinkedList();
        if (repeated) {
            String removeButton;
            series = this.getRepeatedParameter(request, metadataField, metadataField + "_series");
            numbers = this.getRepeatedParameter(request, metadataField, metadataField + "_number");
            String buttonPressed = Util.getSubmitButton(request, "");
            if (buttonPressed.startsWith(removeButton = "submit_" + metadataField + "_remove_")) {
                int valToRemove = Integer.parseInt(buttonPressed.substring(removeButton.length()));
                series.remove(valToRemove);
                numbers.remove(valToRemove);
            }
        } else {
            String s = request.getParameter(metadataField + "_series");
            String n = request.getParameter(metadataField + "_number");
            if (s != null && !s.equals("")) {
                if (n == null) {
                    n = "";
                }
                series.add(s);
                numbers.add(n);
            }
        }
        for (int i = 0; i < series.size(); ++i) {
            String s = ((String)series.get(i)).trim();
            String n = ((String)numbers.get(i)).trim();
            if (s.equals("") && n.equals("")) continue;
            this.itemService.addMetadata(context, item, schema, element, qualifier, null, new DCSeriesNumber(s, n).toString());
        }
    }

    protected List<String> getRepeatedParameter(HttpServletRequest request, String metadataField, String param) {
        LinkedList<String> vals = new LinkedList<String>();
        int i = 1;
        boolean foundLast = false;
        while (!foundLast) {
            String s = null;
            s = request.getParameter(param + "_" + i);
            if (s == null) {
                s = request.getParameter(param);
                foundLast = true;
            }
            if (s != null) {
                boolean addValue = true;
                String[] selected = request.getParameterValues(metadataField + "_selected");
                if (selected != null) {
                    for (int j = 0; j < selected.length; ++j) {
                        if (!selected[j].equals(metadataField + "_" + i)) continue;
                        addValue = false;
                    }
                }
                if (addValue) {
                    vals.add(s.trim());
                }
            }
            ++i;
        }
        log.debug((Object)("getRepeatedParameter: metadataField=" + metadataField + " param=" + metadataField + ", return count = " + vals.size()));
        return vals;
    }

    protected TreeMap<Integer, String> getRepeatedParameterWithTheirIndices(HttpServletRequest request, String metadataField, String param) {
        LinkedHashMap<Integer, String> vals = new LinkedHashMap<Integer, String>();
        int i = 1;
        boolean foundLast = false;
        while (!foundLast) {
            String s = null;
            s = request.getParameter(param + "_" + i);
            if (s == null) {
                s = request.getParameter(param);
                foundLast = true;
            }
            if (s != null) {
                boolean addValue = true;
                String[] selected = request.getParameterValues(metadataField + "_selected");
                if (selected != null) {
                    for (int j = 0; j < selected.length; ++j) {
                        if (!selected[j].equals(metadataField + "_" + i)) continue;
                        addValue = false;
                    }
                }
                if (addValue) {
                    vals.put(i, s.trim());
                }
            }
            ++i;
        }
        log.debug((Object)("getRepeatedParameterWithTheirIndices: metadataField=" + metadataField + " param=" + metadataField + ", return count = " + vals.size()));
        return new TreeMap<Integer, String>(vals);
    }

    public static String getFieldName(DCInput input) {
        String dcSchema = input.getSchema();
        String dcElement = input.getElement();
        String dcQualifier = input.getQualifier();
        if (dcQualifier != null && !dcQualifier.equals("*")) {
            return dcSchema + "_" + dcElement + '_' + dcQualifier;
        }
        return dcSchema + "_" + dcElement;
    }
}

