/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.submit.AbstractProcessingStep;

public class InitialQuestionsStep
extends AbstractProcessingStep {
    public static final int STATUS_VERIFY_PRUNE = 1;
    public static final int STATUS_CANCEL_PRUNE = 2;
    public static final int STATUS_THESIS_REJECTED = 3;
    protected boolean willRemoveTitles = false;
    protected boolean willRemoveDate = false;
    protected boolean willRemoveFiles = false;
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        List<MetadataValue> dateIssued;
        boolean isThesis;
        boolean multipleTitles = Util.getBoolParameter(request, "multiple_titles");
        boolean publishedBefore = Util.getBoolParameter(request, "published_before");
        boolean multipleFiles = Util.getBoolParameter(request, "multiple_files");
        boolean bl = isThesis = this.configurationService.getBooleanProperty("webui.submit.blocktheses") && Util.getBoolParameter(request, "is_thesis");
        if (subInfo.isInWorkflow()) {
            isThesis = false;
            multipleFiles = true;
        }
        if (isThesis) {
            WorkspaceItem wi = (WorkspaceItem)subInfo.getSubmissionItem();
            this.workspaceItemService.deleteAll(context, wi);
            subInfo.setSubmissionItem(null);
            request.getSession().setAttribute("removed_thesis", (Object)Boolean.TRUE);
            return 3;
        }
        Item item = subInfo.getSubmissionItem().getItem();
        if (request.getParameter("do_not_prune") != null) {
            return 2;
        }
        if (request.getParameter("prune") != null) {
            this.processVerifyPrune(context, request, response, subInfo, multipleTitles, publishedBefore, multipleFiles);
        } else {
            if (subInfo.getSubmissionItem() != null) {
                List<Bundle> bundles;
                if (!multipleTitles) {
                    List<MetadataValue> altTitles = this.itemService.getMetadata(item, "dc", "title", "alternative", "*");
                    boolean bl2 = this.willRemoveTitles = altTitles.size() > 0;
                }
                if (!publishedBefore) {
                    dateIssued = this.itemService.getMetadata(item, "dc", "date", "issued", "*");
                    List<MetadataValue> citation = this.itemService.getMetadata(item, "dc", "identifier", "citation", "*");
                    List<MetadataValue> publisher = this.itemService.getMetadata(item, "dc", "publisher", null, "*");
                    boolean bl3 = this.willRemoveDate = dateIssued.size() > 0 || citation.size() > 0 || publisher.size() > 0;
                }
                if (!multipleFiles && (bundles = this.itemService.getBundles(item, "ORIGINAL")).size() > 0) {
                    List<Bitstream> bitstreams = bundles.get(0).getBitstreams();
                    boolean bl4 = this.willRemoveFiles = bitstreams.size() > 1;
                }
            }
            if (this.willRemoveTitles || this.willRemoveDate || this.willRemoveFiles) {
                request.setAttribute("will.remove.titles", (Object)this.willRemoveTitles);
                request.setAttribute("will.remove.date", (Object)this.willRemoveDate);
                request.setAttribute("will.remove.files", (Object)this.willRemoveFiles);
                return 1;
            }
        }
        subInfo.getSubmissionItem().setMultipleTitles(multipleTitles);
        subInfo.getSubmissionItem().setPublishedBefore(publishedBefore);
        if (!subInfo.isInWorkflow()) {
            subInfo.getSubmissionItem().setMultipleFiles(multipleFiles);
        }
        if (!publishedBefore) {
            dateIssued = this.itemService.getMetadata(item, "dc", "date", "issued", "*");
            if (dateIssued.size() == 0) {
                this.itemService.addMetadata(context, item, "dc", "date", "issued", null, "today");
            }
        } else {
            List<MetadataValue> metadata = this.itemService.getMetadata(item, "dc", "date", "issued", "*");
            this.itemService.clearMetadata(context, item, "dc", "date", "issued", "*");
            for (MetadataValue metadataValue : metadata) {
                if (StringUtils.equals((CharSequence)metadataValue.getValue(), (CharSequence)"today")) continue;
                this.itemService.addMetadata(context, item, "dc", "date", "issued", "*", metadataValue.getValue());
            }
        }
        ContentServiceFactory.getInstance().getInProgressSubmissionService(subInfo.getSubmissionItem()).update(context, subInfo.getSubmissionItem());
        context.dispatchEvents();
        return 0;
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }

    protected void processVerifyPrune(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, boolean multipleTitles, boolean publishedBefore, boolean multipleFiles) throws ServletException, IOException, SQLException, AuthorizeException {
        List<Bundle> bundles;
        Item item = subInfo.getSubmissionItem().getItem();
        if (!multipleTitles && subInfo.getSubmissionItem().hasMultipleTitles()) {
            this.itemService.clearMetadata(context, item, "dc", "title", "alternative", "*");
        }
        if (!publishedBefore && subInfo.getSubmissionItem().isPublishedBefore()) {
            this.itemService.clearMetadata(context, item, "dc", "date", "issued", "*");
            this.itemService.clearMetadata(context, item, "dc", "identifier", "citation", "*");
            this.itemService.clearMetadata(context, item, "dc", "publisher", null, "*");
        }
        if (!multipleFiles && subInfo.getSubmissionItem().hasMultipleFiles() && (bundles = this.itemService.getBundles(item, "ORIGINAL")).size() > 0) {
            Iterator<Bitstream> bitstreams = bundles.get(0).getBitstreams().iterator();
            if (bitstreams.hasNext()) {
                bitstreams.next();
            }
            while (bitstreams.hasNext()) {
                Bitstream bitstream = bitstreams.next();
                this.bundleService.removeBitstream(context, bundles.get(0), bitstream);
            }
        }
    }
}

