/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.util.HashSet;
import java.util.Set;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;

public class VersioningConsumer
implements Consumer {
    private static Set<Item> itemsToProcess;
    private VersionHistoryService versionHistoryService;
    private VersioningService versioningService;
    private ItemService itemService;

    @Override
    public void initialize() throws Exception {
        this.versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();
        this.versioningService = VersionServiceFactory.getInstance().getVersionService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        Item previousItem;
        Version latest;
        Version previous;
        VersionHistory history;
        Item item;
        if (itemsToProcess == null) {
            itemsToProcess = new HashSet<Item>();
        }
        int st = event.getSubjectType();
        int et = event.getEventType();
        if (st == 2 && et == 64 && (item = (Item)event.getSubject(ctx)) != null && item.isArchived() && (history = this.versionHistoryService.findByItem(ctx, item)) != null && (previous = this.versionHistoryService.getPrevious(ctx, history, latest = this.versionHistoryService.getLatestVersion(ctx, history))) != null && (previousItem = previous.getItem()) != null) {
            previousItem.setArchived(false);
            itemsToProcess.add(previousItem);
            ctx.addEvent(new Event(2, previousItem.getType(), previousItem.getID(), null, this.itemService.getIdentifiers(ctx, previousItem)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Context ctx) throws Exception {
        if (itemsToProcess != null) {
            for (Item item : itemsToProcess) {
                ctx.turnOffAuthorisationSystem();
                try {
                    this.itemService.update(ctx, item);
                }
                finally {
                    ctx.restoreAuthSystemState();
                }
            }
        }
        itemsToProcess = null;
    }
}

