/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.statistics;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.statistics.LogLine;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;

public class LogAnalyser {
    private static Map<String, Integer> actionAggregator;
    private static Map<String, Integer> searchAggregator;
    private static Map<String, Integer> userAggregator;
    private static Map<String, Integer> itemAggregator;
    private static Map<String, Integer> archiveStats;
    private static int warnCount;
    private static int excCount;
    private static int lineCount;
    private static List<String> generalSummary;
    private static List<String> excludeWords;
    private static List<String> excludeTypes;
    private static List<String> excludeChars;
    private static List<String> itemTypes;
    private static int searchFloor;
    private static int itemFloor;
    private static int itemLookup;
    private static String userEmail;
    private static String url;
    private static String name;
    private static String hostName;
    private static int views;
    private static Pattern excludeCharRX;
    private static Pattern handleRX;
    private static Pattern itemRX;
    private static Pattern queryRX;
    private static Pattern collectionRX;
    private static Pattern communityRX;
    private static Pattern resultsRX;
    private static Pattern singleRX;
    private static Pattern valid13;
    private static Pattern validBase;
    private static Pattern valid14;
    private static Pattern logRegex;
    private static final Pattern comment;
    private static final Pattern real;
    private static Pattern typeRX;
    private static Pattern wordRX;
    private static Calendar startTime;
    private static String logDir;
    private static String fileTemplate;
    private static String configFile;
    private static String outFile;
    private static Date startDate;
    private static Date endDate;
    private static Date logStartDate;
    private static Date logEndDate;

    private LogAnalyser() {
    }

    public static void main(String[] argv) throws Exception, SQLException {
        startTime = new GregorianCalendar();
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        String myLogDir = null;
        String myFileTemplate = null;
        String myConfigFile = null;
        String myOutFile = null;
        Date myStartDate = null;
        Date myEndDate = null;
        boolean myLookUp = false;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-log")) {
                myLogDir = argv[i + 1];
            }
            if (argv[i].equals("-file")) {
                myFileTemplate = argv[i + 1];
            }
            if (argv[i].equals("-cfg")) {
                myConfigFile = argv[i + 1];
            }
            if (argv[i].equals("-out")) {
                myOutFile = argv[i + 1];
            }
            if (argv[i].equals("-help")) {
                LogAnalyser.usage();
                System.exit(0);
            }
            if (argv[i].equals("-start")) {
                myStartDate = LogAnalyser.parseDate(argv[i + 1]);
            }
            if (argv[i].equals("-end")) {
                myEndDate = LogAnalyser.parseDate(argv[i + 1]);
            }
            if (!argv[i].equals("-lookup")) continue;
            myLookUp = true;
        }
        LogAnalyser.processLogs(context, myLogDir, myFileTemplate, myConfigFile, myOutFile, myStartDate, myEndDate, myLookUp);
    }

    public static String processLogs(Context context, String myLogDir, String myFileTemplate, String myConfigFile, String myOutFile, Date myStartDate, Date myEndDate, boolean myLookUp) throws IOException, SQLException, SearchServiceException {
        startTime = new GregorianCalendar();
        actionAggregator = new HashMap<String, Integer>();
        searchAggregator = new HashMap<String, Integer>();
        userAggregator = new HashMap<String, Integer>();
        itemAggregator = new HashMap<String, Integer>();
        archiveStats = new HashMap<String, Integer>();
        generalSummary = new ArrayList<String>();
        excludeWords = new ArrayList<String>();
        excludeTypes = new ArrayList<String>();
        excludeChars = new ArrayList<String>();
        itemTypes = new ArrayList<String>();
        LogAnalyser.setParameters(myLogDir, myFileTemplate, myConfigFile, myOutFile, myStartDate, myEndDate, myLookUp);
        FileReader fr = null;
        BufferedReader br = null;
        LogAnalyser.readConfig(configFile);
        LogAnalyser.setRegex(fileTemplate);
        File[] logFiles = LogAnalyser.getLogFiles(logDir);
        int i = 0;
        for (i = 0; i < logFiles.length; ++i) {
            Matcher matchRegex = logRegex.matcher(logFiles[i].getName());
            if (!matchRegex.matches()) continue;
            try {
                fr = new FileReader(logFiles[i].toString());
                br = new BufferedReader(fr);
            }
            catch (IOException e) {
                System.out.println("Failed to read log file " + logFiles[i].toString());
                System.exit(0);
            }
            String line = null;
            while ((line = br.readLine()) != null) {
                LogLine logLine = LogAnalyser.getLogLine(line);
                if (logLine == null || startDate != null && !logLine.afterDate(startDate)) continue;
                if (endDate != null && !logLine.beforeDate(endDate)) break;
                ++lineCount;
                if (startDate == null) {
                    if (logStartDate != null) {
                        if (logLine.beforeDate(logStartDate)) {
                            logStartDate = logLine.getDate();
                        }
                    } else {
                        logStartDate = logLine.getDate();
                    }
                }
                if (endDate == null) {
                    if (logEndDate != null) {
                        if (logLine.afterDate(logEndDate)) {
                            logEndDate = logLine.getDate();
                        }
                    } else {
                        logEndDate = logLine.getDate();
                    }
                }
                if (logLine.isLevel("WARN")) {
                    ++warnCount;
                }
                if (logLine.isLevel("ERROR")) {
                    ++excCount;
                }
                if (null == logLine.getAction()) continue;
                if (logLine.isAction("search")) {
                    String[] words = LogAnalyser.analyseQuery(logLine.getParams());
                    for (int j = 0; j < words.length; ++j) {
                        searchAggregator.put(words[j], LogAnalyser.increment(searchAggregator, words[j]));
                    }
                }
                if (logLine.isAction("login") && !userEmail.equals("off")) {
                    userAggregator.put(logLine.getUser(), LogAnalyser.increment(userAggregator, logLine.getUser()));
                }
                if (logLine.isAction("view_item")) {
                    String handle = logLine.getParams();
                    Matcher matchHandle = handleRX.matcher(handle);
                    handle = matchHandle.replaceAll("");
                    Matcher matchItem = itemRX.matcher(handle);
                    handle = matchItem.replaceAll("").trim();
                    itemAggregator.put(handle, LogAnalyser.increment(itemAggregator, handle));
                }
                actionAggregator.put(logLine.getAction(), LogAnalyser.increment(actionAggregator, logLine.getAction()));
            }
            br.close();
            fr.close();
        }
        archiveStats.put("All Items", LogAnalyser.getNumItems(context));
        for (i = 0; i < itemTypes.size(); ++i) {
            archiveStats.put(itemTypes.get(i), LogAnalyser.getNumItems(context, itemTypes.get(i)));
        }
        hostName = Utils.getHostName(ConfigurationManager.getProperty("dspace.ui.url"));
        name = ConfigurationManager.getProperty("dspace.name").trim();
        url = ConfigurationManager.getProperty("dspace.ui.url").trim();
        if (url != null && !url.endsWith("/")) {
            url = url + "/";
        }
        if (archiveStats.get("All Items") != 0) {
            Double avg = Math.ceil(actionAggregator.get("view_item").doubleValue() / archiveStats.get("All Items").doubleValue());
            views = avg.intValue();
        }
        return LogAnalyser.createOutput();
    }

    public static void setParameters(String myLogDir, String myFileTemplate, String myConfigFile, String myOutFile, Date myStartDate, Date myEndDate, boolean myLookUp) {
        if (myLogDir != null) {
            logDir = myLogDir;
        }
        if (myFileTemplate != null) {
            fileTemplate = myFileTemplate;
        }
        if (myConfigFile != null) {
            configFile = myConfigFile;
        }
        if (myStartDate != null) {
            startDate = new Date(myStartDate.getTime());
        }
        if (myEndDate != null) {
            endDate = new Date(myEndDate.getTime());
        }
        if (myOutFile != null) {
            outFile = myOutFile;
        }
    }

    public static String createOutput() {
        StringBuffer summary = new StringBuffer();
        Iterator<String> keys = null;
        summary.append("log_lines=" + Integer.toString(lineCount) + "\n");
        summary.append("warnings=" + Integer.toString(warnCount) + "\n");
        summary.append("exceptions=" + Integer.toString(excCount) + "\n");
        for (int i = 0; i < generalSummary.size(); ++i) {
            summary.append("general_summary=" + generalSummary.get(i) + "\n");
        }
        summary.append("server_name=" + hostName + "\n");
        summary.append("service_name=" + name + "\n");
        SimpleDateFormat sdf = new SimpleDateFormat("dd'/'MM'/'yyyy");
        if (startDate != null) {
            summary.append("start_date=" + sdf.format(startDate) + "\n");
        } else if (logStartDate != null) {
            summary.append("start_date=" + sdf.format(logStartDate) + "\n");
        }
        if (endDate != null) {
            summary.append("end_date=" + sdf.format(endDate) + "\n");
        } else if (logEndDate != null) {
            summary.append("end_date=" + sdf.format(logEndDate) + "\n");
        }
        for (String key : archiveStats.keySet()) {
            summary.append("archive." + key + "=" + archiveStats.get(key) + "\n");
        }
        for (String key : actionAggregator.keySet()) {
            summary.append("action." + key + "=" + actionAggregator.get(key) + "\n");
        }
        summary.append("user_email=" + userEmail + "\n");
        int address = 1;
        for (String key : userAggregator.keySet()) {
            summary.append("user.");
            if (userEmail.equals("on")) {
                summary.append(key + "=" + userAggregator.get(key) + "\n");
                continue;
            }
            if (!userEmail.equals("alias")) continue;
            summary.append("Address " + Integer.toString(address++) + "=" + userAggregator.get(key) + "\n");
        }
        summary.append("search_floor=" + searchFloor + "\n");
        for (String key : searchAggregator.keySet()) {
            if (searchAggregator.get(key) < searchFloor) continue;
            summary.append("search." + key + "=" + searchAggregator.get(key) + "\n");
        }
        summary.append("item_floor=" + itemFloor + "\n");
        summary.append("host_url=" + url + "\n");
        summary.append("item_lookup=" + itemLookup + "\n");
        for (String key : itemAggregator.keySet()) {
            if (itemAggregator.get(key) < itemFloor) continue;
            summary.append("item." + key + "=" + itemAggregator.get(key) + "\n");
        }
        if (views > 0) {
            summary.append("avg_item_views=" + views + "\n");
        }
        GregorianCalendar endTime = new GregorianCalendar();
        long timeInMillis = endTime.getTimeInMillis() - startTime.getTimeInMillis();
        summary.append("analysis_process_time=" + Long.toString(timeInMillis / 1000L) + "\n");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
            out.write(summary.toString());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Unable to write to output file " + outFile);
            System.exit(0);
        }
        return summary.toString();
    }

    public static File[] getLogFiles(String logDir) {
        File logs = new File(logDir);
        if (!logs.isDirectory()) {
            System.out.println("Passed log directory is not a directory");
            System.exit(0);
        }
        return logs.listFiles();
    }

    public static void setRegex(String fileTemplate) {
        StringBuffer charRegEx = new StringBuffer();
        charRegEx.append("[");
        for (int i = 0; i < excludeChars.size(); ++i) {
            charRegEx.append("\\").append(excludeChars.get(i));
        }
        charRegEx.append("]");
        excludeCharRX = Pattern.compile(charRegEx.toString());
        handleRX = Pattern.compile("handle=");
        itemRX = Pattern.compile(",item_id=.*$");
        queryRX = Pattern.compile("query=");
        collectionRX = Pattern.compile("collection_id=[0-9]*,");
        communityRX = Pattern.compile("community_id=[0-9]*,");
        resultsRX = Pattern.compile(",results=(.*)");
        singleRX = Pattern.compile("( . |^. | .$)");
        String logLineBase = "^(\\d\\d\\d\\d-\\d\\d\\-\\d\\d) \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d (\\w+)\\s+\\S+ @ (.*)";
        String logLine13 = "^(\\d\\d\\d\\d-\\d\\d\\-\\d\\d) \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d (\\w+)\\s+\\S+ @ ([^:]+):[^:]+:([^:]+):(.*)";
        String logLine14 = "^(\\d\\d\\d\\d-\\d\\d\\-\\d\\d) \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d (\\w+)\\s+\\S+ @ ([^:]+):[^:]+:[^:]+:([^:]+):(.*)";
        valid13 = Pattern.compile(logLine13);
        valid14 = Pattern.compile(logLine14);
        validBase = Pattern.compile(logLineBase);
        logRegex = Pattern.compile(fileTemplate);
        StringBuffer typeRXString = new StringBuffer();
        typeRXString.append("(");
        for (int i = 0; i < excludeTypes.size(); ++i) {
            if (i > 0) {
                typeRXString.append("|");
            }
            typeRXString.append(excludeTypes.get(i));
        }
        typeRXString.append(")");
        typeRX = Pattern.compile(typeRXString.toString());
        StringBuffer wordRXString = new StringBuffer();
        wordRXString.append("(");
        for (int i = 0; i < excludeWords.size(); ++i) {
            if (i > 0) {
                wordRXString.append("|");
            }
            wordRXString.append(" " + excludeWords.get(i) + " ");
            wordRXString.append("|");
            wordRXString.append("^" + excludeWords.get(i) + " ");
            wordRXString.append("|");
            wordRXString.append(" " + excludeWords.get(i) + "$");
        }
        wordRXString.append(")");
        wordRX = Pattern.compile(wordRXString.toString());
    }

    public static String getConfigFile() {
        return configFile;
    }

    public static void readConfig() throws IOException {
        LogAnalyser.readConfig(configFile);
    }

    public static void readConfig(String configFile) throws IOException {
        actionAggregator = new HashMap<String, Integer>();
        searchAggregator = new HashMap<String, Integer>();
        userAggregator = new HashMap<String, Integer>();
        itemAggregator = new HashMap<String, Integer>();
        archiveStats = new HashMap<String, Integer>();
        generalSummary = new ArrayList<String>();
        excludeWords = new ArrayList<String>();
        excludeTypes = new ArrayList<String>();
        excludeChars = new ArrayList<String>();
        itemTypes = new ArrayList<String>();
        FileReader fr = null;
        BufferedReader br = null;
        String record = null;
        try {
            fr = new FileReader(configFile);
            br = new BufferedReader(fr);
        }
        catch (IOException e) {
            System.out.println("Failed to read config file: " + configFile);
            System.exit(0);
        }
        while ((record = br.readLine()) != null) {
            Matcher matchComment = comment.matcher(record);
            Matcher matchReal = real.matcher(record);
            if (matchComment.matches() || !matchReal.matches()) continue;
            String key = matchReal.group(1).trim();
            String value = matchReal.group(2).trim();
            if (key.equals("general.summary")) {
                actionAggregator.put(value, 0);
                generalSummary.add(value);
            }
            if (key.equals("exclude.word")) {
                excludeWords.add(value);
            }
            if (key.equals("exclude.type")) {
                excludeTypes.add(value);
            }
            if (key.equals("exclude.character")) {
                excludeChars.add(value);
            }
            if (key.equals("item.type")) {
                itemTypes.add(value);
            }
            if (key.equals("item.floor")) {
                itemFloor = Integer.parseInt(value);
            }
            if (key.equals("search.floor")) {
                searchFloor = Integer.parseInt(value);
            }
            if (key.equals("item.lookup")) {
                itemLookup = Integer.parseInt(value);
            }
            if (!key.equals("user.email")) continue;
            userEmail = value;
        }
        br.close();
        fr.close();
    }

    public static Integer increment(Map<String, Integer> map, String key) {
        Integer newValue = null;
        newValue = map.containsKey(key) ? Integer.valueOf(map.get(key) + 1) : Integer.valueOf(1);
        return newValue;
    }

    public static Date parseDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd");
        Date parsedDate = null;
        try {
            parsedDate = sdf.parse(date);
        }
        catch (ParseException e) {
            System.out.println("The date is not in the correct format");
            System.exit(0);
        }
        return parsedDate;
    }

    public static String unParseDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd'T'hh:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    public static String[] analyseQuery(String query) {
        int i = 0;
        query = query.toLowerCase();
        Matcher matchQuery = queryRX.matcher(query);
        query = matchQuery.replaceAll(" ");
        Matcher matchCollection = collectionRX.matcher(query);
        query = matchCollection.replaceAll(" ");
        Matcher matchCommunity = communityRX.matcher(query);
        query = matchCommunity.replaceAll(" ");
        Matcher matchResults = resultsRX.matcher(query);
        query = matchResults.replaceAll(" ");
        Matcher matchTypes = typeRX.matcher(query);
        query = matchTypes.replaceAll(" ");
        Matcher matchChars = excludeCharRX.matcher(query);
        query = matchChars.replaceAll(" ");
        Matcher matchWords = wordRX.matcher(query);
        query = matchWords.replaceAll(" ");
        Matcher single = singleRX.matcher(query);
        query = single.replaceAll(" ");
        StringTokenizer st = new StringTokenizer(query);
        String[] words = new String[st.countTokens()];
        for (i = 0; i < words.length; ++i) {
            words[i] = st.nextToken().trim();
        }
        return words;
    }

    public static LogLine getLogLine(String line) {
        Matcher match = line.indexOf(":ip_addr") > 0 ? valid14.matcher(line) : valid13.matcher(line);
        if (match.matches()) {
            LogLine logLine = new LogLine(LogAnalyser.parseDate(match.group(1).trim()), LogManager.unescapeLogField(match.group(2)).trim(), LogManager.unescapeLogField(match.group(3)).trim(), LogManager.unescapeLogField(match.group(4)).trim(), LogManager.unescapeLogField(match.group(5)).trim());
            return logLine;
        }
        match = validBase.matcher(line);
        if (match.matches()) {
            LogLine logLine = new LogLine(LogAnalyser.parseDate(match.group(1).trim()), LogManager.unescapeLogField(match.group(2)).trim(), null, null, null);
            return logLine;
        }
        return null;
    }

    public static Integer getNumItems(Context context, String type) throws SQLException, SearchServiceException {
        DiscoverQuery discoverQuery = new DiscoverQuery();
        if (StringUtils.isNotBlank((CharSequence)type)) {
            discoverQuery.addFilterQueries("dc.type=" + type + "*");
        }
        StringBuilder accessionedQuery = new StringBuilder();
        accessionedQuery.append("dc.date.accessioned_dt:[");
        if (startDate != null) {
            accessionedQuery.append(LogAnalyser.unParseDate(startDate));
        } else {
            accessionedQuery.append("*");
        }
        accessionedQuery.append(" TO ");
        if (endDate != null) {
            accessionedQuery.append(LogAnalyser.unParseDate(endDate));
        } else {
            accessionedQuery.append("*");
        }
        accessionedQuery.append("]");
        discoverQuery.addFilterQueries(accessionedQuery.toString());
        discoverQuery.addFilterQueries("withdrawn: false");
        discoverQuery.addFilterQueries("archived: true");
        return (int)SearchUtils.getSearchService().search(context, discoverQuery).getTotalSearchResults();
    }

    public static Integer getNumItems(Context context) throws SQLException, SearchServiceException {
        return LogAnalyser.getNumItems(context, null);
    }

    public static void usage() {
        String usage = "Usage Information:\nLogAnalyser [options [parameters]]\n-log [log directory]\n\tOptional\n\tSpecify a directory containing log files\n\tDefault uses [dspace.dir]/log from dspace.cfg\n-file [file name regex]\n\tOptional\n\tSpecify a regular expression as the file name template.\n\tCurrently this needs to be correctly escaped for Java string handling (FIXME)\n\tDefault uses dspace.log*\n-cfg [config file path]\n\tOptional\n\tSpecify a config file to be used\n\tDefault uses dstat.cfg in dspace config directory\n-out [output file path]\n\tOptional\n\tSpecify an output file to write results into\n\tDefault uses dstat.dat in dspace log directory\n-start [YYYY-MM-DD]\n\tOptional\n\tSpecify the start date of the analysis\n\tIf a start date is specified then no attempt to gather \n\tcurrent database statistics will be made unless -lookup is\n\talso passed\n\tDefault is to start from the earliest date records exist for\n-end [YYYY-MM-DD]\n\tOptional\n\tSpecify the end date of the analysis\n\tIf an end date is specified then no attempt to gather \n\tcurrent database statistics will be made unless -lookup is\n\talso passed\n\tDefault is to work up to the last date records exist for\n-lookup\n\tOptional\n\tForce a lookup of the current database statistics\n\tOnly needs to be used if date constraints are also in place\n-help\n\tdisplay this usage information\n";
        System.out.println(usage);
    }

    static {
        warnCount = 0;
        excCount = 0;
        lineCount = 0;
        views = 0;
        excludeCharRX = null;
        handleRX = null;
        itemRX = null;
        queryRX = null;
        collectionRX = null;
        communityRX = null;
        resultsRX = null;
        singleRX = null;
        valid13 = null;
        validBase = null;
        valid14 = null;
        logRegex = null;
        comment = Pattern.compile("^#");
        real = Pattern.compile("^(.+)=(.+)");
        typeRX = null;
        wordRX = null;
        startTime = null;
        logDir = ConfigurationManager.getProperty("log.report.dir");
        fileTemplate = "dspace\\.log.*";
        configFile = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "dstat.cfg";
        outFile = ConfigurationManager.getProperty("log.report.dir") + File.separator + "dstat.dat";
        startDate = null;
        endDate = null;
        logStartDate = null;
        logEndDate = null;
    }
}

