/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;

public class AuthorizeUtil {
    private AuthorizeUtil() {
    }

    public static void authorizeManageBitstreamPolicy(Context context, Bitstream bitstream) throws AuthorizeException, SQLException {
        Bundle bundle = bitstream.getBundles().get(0);
        AuthorizeUtil.authorizeManageBundlePolicy(context, bundle);
    }

    public static void authorizeManageBundlePolicy(Context context, Bundle bundle) throws AuthorizeException, SQLException {
        Item item = bundle.getItems().get(0);
        AuthorizeUtil.authorizeManageItemPolicy(context, item);
    }

    public static void authorizeManageItemPolicy(Context context, Item item) throws AuthorizeException, SQLException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        if (AuthorizeConfiguration.canItemAdminManagePolicies()) {
            AuthorizeServiceFactory.getInstance().getAuthorizeService().authorizeAction(context, item, 11);
        } else if (AuthorizeConfiguration.canCollectionAdminManageItemPolicies()) {
            authorizeService.authorizeAction(context, item.getOwningCollection(), 11);
        } else if (AuthorizeConfiguration.canCommunityAdminManageItemPolicies()) {
            authorizeService.authorizeAction(context, item.getOwningCollection().getCommunities().get(0), 11);
        } else if (!authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage item policies");
        }
    }

    public static void authorizeManageCollectionPolicy(Context context, Collection collection) throws AuthorizeException, SQLException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        if (AuthorizeConfiguration.canCollectionAdminManagePolicies()) {
            authorizeService.authorizeAction(context, collection, 11);
        } else if (AuthorizeConfiguration.canCommunityAdminManageCollectionPolicies()) {
            authorizeService.authorizeAction(context, collection.getCommunities().get(0), 11);
        } else if (!authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage collection policies");
        }
    }

    public static void authorizeManageCommunityPolicy(Context context, Community community) throws AuthorizeException, SQLException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        if (AuthorizeConfiguration.canCommunityAdminManagePolicies()) {
            authorizeService.authorizeAction(context, community, 11);
        } else if (!authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage community policies");
        }
    }

    public static void requireAdminRole(Context context) throws AuthorizeException, SQLException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        if (!authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to perform this action");
        }
    }

    public static void authorizeManageCCLicense(Context context, Item item) throws AuthorizeException, SQLException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        ItemService itemService = ContentServiceFactory.getInstance().getItemService();
        try {
            authorizeService.authorizeAction(context, item, 3);
            authorizeService.authorizeAction(context, item, 4);
        }
        catch (AuthorizeException authex) {
            if (AuthorizeConfiguration.canItemAdminManageCCLicense()) {
                authorizeService.authorizeAction(context, item, 11);
            }
            if (AuthorizeConfiguration.canCollectionAdminManageCCLicense()) {
                authorizeService.authorizeAction(context, itemService.getParentObject(context, item), 11);
            }
            if (AuthorizeConfiguration.canCommunityAdminManageCCLicense()) {
                authorizeService.authorizeAction(context, itemService.getParentObject(context, item), 11);
            }
            AuthorizeUtil.requireAdminRole(context);
        }
    }

    public static void authorizeManageTemplateItem(Context context, Collection collection) throws AuthorizeException, SQLException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
        boolean isAuthorized = collectionService.canEditBoolean(context, collection, false);
        if (!isAuthorized && AuthorizeConfiguration.canCollectionAdminManageTemplateItem()) {
            authorizeService.authorizeAction(context, collection, 11);
        } else if (!isAuthorized && AuthorizeConfiguration.canCommunityAdminManageCollectionTemplateItem()) {
            List<Community> communities = collection.getCommunities();
            Community parent = communities != null && communities.size() > 0 ? communities.get(0) : null;
            authorizeService.authorizeAction(context, parent, 11);
        } else if (!isAuthorized && !authorizeService.isAdmin(context)) {
            throw new AuthorizeException("You are not authorized to create a template item for the collection");
        }
    }

    public static void authorizeManageSubmittersGroup(Context context, Collection collection) throws AuthorizeException, SQLException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        if (AuthorizeConfiguration.canCollectionAdminManageSubmitters()) {
            authorizeService.authorizeAction(context, collection, 11);
        } else if (AuthorizeConfiguration.canCommunityAdminManageCollectionSubmitters()) {
            authorizeService.authorizeAction(context, collection.getCommunities().get(0), 11);
        } else if (!authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage collection submitters");
        }
    }

    public static void authorizeManageWorkflowsGroup(Context context, Collection collection) throws AuthorizeException, SQLException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        if (AuthorizeConfiguration.canCollectionAdminManageWorkflows()) {
            authorizeService.authorizeAction(context, collection, 11);
        } else if (AuthorizeConfiguration.canCommunityAdminManageCollectionWorkflows()) {
            authorizeService.authorizeAction(context, collection.getCommunities().get(0), 11);
        } else if (!authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage collection workflow");
        }
    }

    public static void authorizeManageAdminGroup(Context context, Collection collection) throws AuthorizeException, SQLException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        if (AuthorizeConfiguration.canCollectionAdminManageAdminGroup()) {
            authorizeService.authorizeAction(context, collection, 11);
        } else if (AuthorizeConfiguration.canCommunityAdminManageCollectionAdminGroup()) {
            authorizeService.authorizeAction(context, collection.getCommunities().get(0), 11);
        } else if (!authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage collection admin");
        }
    }

    public static void authorizeRemoveAdminGroup(Context context, Collection collection) throws AuthorizeException, SQLException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        List<Community> parentCommunities = collection.getCommunities();
        if (AuthorizeConfiguration.canCommunityAdminManageCollectionAdminGroup() && parentCommunities != null && parentCommunities.size() > 0) {
            authorizeService.authorizeAction(context, collection.getCommunities().get(0), 11);
        } else if (!authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only system admin can remove the admin group of a collection");
        }
    }

    public static void authorizeManageAdminGroup(Context context, Community community) throws AuthorizeException, SQLException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        if (AuthorizeConfiguration.canCommunityAdminManageAdminGroup()) {
            authorizeService.authorizeAction(context, community, 11);
        } else if (!authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage community admin");
        }
    }

    public static void authorizeRemoveAdminGroup(Context context, Community community) throws SQLException, AuthorizeException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        List<Community> parentCommunities = community.getParentCommunities();
        Community parentCommunity = null;
        if (0 < parentCommunities.size()) {
            parentCommunity = parentCommunities.get(0);
        }
        if (AuthorizeConfiguration.canCommunityAdminManageAdminGroup() && parentCommunity != null) {
            authorizeService.authorizeAction(context, parentCommunity, 11);
        } else if (!authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only system admin can remove the admin group of the community");
        }
    }

    public static void authorizeManagePolicy(Context c, ResourcePolicy rp) throws SQLException, AuthorizeException {
        switch (rp.getdSpaceObject().getType()) {
            case 0: {
                AuthorizeUtil.authorizeManageBitstreamPolicy(c, (Bitstream)rp.getdSpaceObject());
                break;
            }
            case 1: {
                AuthorizeUtil.authorizeManageBundlePolicy(c, (Bundle)rp.getdSpaceObject());
                break;
            }
            case 2: {
                AuthorizeUtil.authorizeManageItemPolicy(c, (Item)rp.getdSpaceObject());
                break;
            }
            case 3: {
                AuthorizeUtil.authorizeManageCollectionPolicy(c, (Collection)rp.getdSpaceObject());
                break;
            }
            case 4: {
                AuthorizeUtil.authorizeManageCommunityPolicy(c, (Community)rp.getdSpaceObject());
                break;
            }
            default: {
                AuthorizeUtil.requireAdminRole(c);
            }
        }
    }

    public static void authorizeWithdrawItem(Context context, Item item) throws SQLException, AuthorizeException {
        boolean authorized = false;
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        if (AuthorizeConfiguration.canCollectionAdminPerformItemWithdrawn()) {
            authorized = authorizeService.authorizeActionBoolean(context, item.getOwningCollection(), 11);
        } else if (AuthorizeConfiguration.canCommunityAdminPerformItemWithdrawn()) {
            authorized = authorizeService.authorizeActionBoolean(context, item.getOwningCollection().getCommunities().get(0), 11);
        }
        if (!authorized) {
            authorized = authorizeService.authorizeActionBoolean(context, item.getOwningCollection(), 4, false);
        }
        if (!authorized) {
            throw new AuthorizeException("To withdraw item must be COLLECTION_ADMIN or have REMOVE authorization on owning Collection");
        }
    }

    public static void authorizeReinstateItem(Context context, Item item) throws SQLException, AuthorizeException {
        AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        List<Collection> colls = item.getCollections();
        for (Collection coll : colls) {
            if (!AuthorizeConfiguration.canCollectionAdminPerformItemReinstatiate()) {
                if (AuthorizeConfiguration.canCommunityAdminPerformItemReinstatiate() && authorizeService.authorizeActionBoolean(context, coll.getCommunities().get(0), 11)) continue;
                authorizeService.authorizeAction(context, coll, 3, false);
                continue;
            }
            authorizeService.authorizeAction(context, coll, 3);
        }
    }
}

