/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.checker.BitstreamDispatcher;
import org.dspace.checker.IteratorDispatcher;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;

public class HandleDispatcher
implements BitstreamDispatcher {
    private static final Logger LOG = LogManager.getLogger(HandleDispatcher.class);
    protected Context context;
    protected String handle = null;
    protected boolean init = false;
    protected IteratorDispatcher delegate = null;
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    private HandleDispatcher() {
    }

    public HandleDispatcher(Context context, String hdl) {
        this.context = context;
        this.handle = hdl;
    }

    protected synchronized void init() throws SQLException {
        if (!this.init) {
            DSpaceObject dso = this.handleService.resolveToObject(this.context, this.handle);
            Iterator<Bitstream> ids = new ArrayList().iterator();
            switch (dso.getType()) {
                case 0: {
                    ids = Arrays.asList((Bitstream)dso).iterator();
                    break;
                }
                case 2: {
                    ids = this.bitstreamService.getItemBitstreams(this.context, (Item)dso);
                    break;
                }
                case 3: {
                    ids = this.bitstreamService.getCollectionBitstreams(this.context, (Collection)dso);
                    break;
                }
                case 4: {
                    ids = this.bitstreamService.getCommunityBitstreams(this.context, (Community)dso);
                    break;
                }
            }
            this.delegate = new IteratorDispatcher(ids);
            this.init = true;
        }
    }

    @Override
    public Bitstream next() throws SQLException {
        if (!this.init) {
            this.init();
        }
        return this.delegate.next();
    }
}

