/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.WorkspaceItem_;
import org.dspace.content.dao.WorkspaceItemDAO;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPerson_;

public class WorkspaceItemDAOImpl
extends AbstractHibernateDAO<WorkspaceItem>
implements WorkspaceItemDAO {
    protected WorkspaceItemDAOImpl() {
    }

    @Override
    public List<WorkspaceItem> findByEPerson(Context context, EPerson ep) throws SQLException {
        Query query = this.createQuery(context, "from WorkspaceItem ws where ws.item.submitter = :submitter order by workspaceItemId");
        query.setParameter("submitter", (Object)ep);
        return this.list(query);
    }

    @Override
    public List<WorkspaceItem> findByEPerson(Context context, EPerson ep, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<WorkspaceItem> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, WorkspaceItem.class);
        Root workspaceItemRoot = criteriaQuery.from(WorkspaceItem.class);
        criteriaQuery.select((Selection)workspaceItemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)workspaceItemRoot.get(WorkspaceItem_.item).get("submitter"), (Object)ep));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)workspaceItemRoot.get(WorkspaceItem_.workspaceItemId))});
        return this.list(context, criteriaQuery, false, WorkspaceItem.class, limit, offset);
    }

    @Override
    public List<WorkspaceItem> findByCollection(Context context, Collection c) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<WorkspaceItem> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, WorkspaceItem.class);
        Root workspaceItemRoot = criteriaQuery.from(WorkspaceItem.class);
        criteriaQuery.select((Selection)workspaceItemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)workspaceItemRoot.get(WorkspaceItem_.collection), (Object)c));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)workspaceItemRoot.get(WorkspaceItem_.workspaceItemId))});
        return this.list(context, criteriaQuery, false, WorkspaceItem.class, -1, -1);
    }

    @Override
    public WorkspaceItem findByItem(Context context, Item i) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<WorkspaceItem> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, WorkspaceItem.class);
        Root workspaceItemRoot = criteriaQuery.from(WorkspaceItem.class);
        criteriaQuery.select((Selection)workspaceItemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)workspaceItemRoot.get(WorkspaceItem_.item), (Object)i));
        return this.uniqueResult(context, criteriaQuery, false, WorkspaceItem.class, -1, -1);
    }

    @Override
    public List<WorkspaceItem> findAll(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<WorkspaceItem> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, WorkspaceItem.class);
        Root workspaceItemRoot = criteriaQuery.from(WorkspaceItem.class);
        criteriaQuery.select((Selection)workspaceItemRoot);
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)workspaceItemRoot.get(WorkspaceItem_.workspaceItemId)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, WorkspaceItem.class, -1, -1);
    }

    @Override
    public List<WorkspaceItem> findAll(Context context, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<WorkspaceItem> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, WorkspaceItem.class);
        Root workspaceItemRoot = criteriaQuery.from(WorkspaceItem.class);
        criteriaQuery.select((Selection)workspaceItemRoot);
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)workspaceItemRoot.get(WorkspaceItem_.workspaceItemId)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, WorkspaceItem.class, limit, offset);
    }

    @Override
    public List<WorkspaceItem> findWithSupervisedGroup(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<WorkspaceItem> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, WorkspaceItem.class);
        Root workspaceItemRoot = criteriaQuery.from(WorkspaceItem.class);
        criteriaQuery.select((Selection)workspaceItemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.isNotEmpty(workspaceItemRoot.get(WorkspaceItem_.supervisorGroups)));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)workspaceItemRoot.get(WorkspaceItem_.workspaceItemId)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, WorkspaceItem.class, -1, -1);
    }

    @Override
    public List<WorkspaceItem> findBySupervisedGroupMember(Context context, EPerson ePerson) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<WorkspaceItem> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, WorkspaceItem.class);
        Root workspaceItemRoot = criteriaQuery.from(WorkspaceItem.class);
        Join join = workspaceItemRoot.join("supervisorGroups");
        Join secondJoin = join.join("epeople");
        criteriaQuery.select((Selection)workspaceItemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)secondJoin.get(EPerson_.id), (Object)ePerson.getID()));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)workspaceItemRoot.get(WorkspaceItem_.workspaceItemId))});
        return this.list(context, criteriaQuery, false, WorkspaceItem.class, -1, -1);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) from WorkspaceItem"));
    }

    @Override
    public int countRows(Context context, EPerson ep) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) from WorkspaceItem ws where ws.item.submitter = :submitter");
        query.setParameter("submitter", (Object)ep);
        return this.count(query);
    }

    @Override
    public List<Map.Entry<Integer, Long>> getStageReachedCounts(Context context) throws SQLException {
        Query query = this.createQuery(context, "SELECT wi.stageReached as stage_reached, count(*) as cnt from WorkspaceItem wi group by wi.stageReached order by wi.stageReached");
        List list = query.getResultList();
        LinkedList<Map.Entry<Integer, Long>> returnList = new LinkedList<Map.Entry<Integer, Long>>();
        for (Object[] o : list) {
            returnList.add(new AbstractMap.SimpleEntry<Integer, Long>((Integer)o[0], (Long)o[1]));
        }
        return returnList;
    }
}

