/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sort.OrderFormat;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServiceMetadataBrowseIndexingPlugin
implements SolrServiceIndexPlugin {
    private static final Logger log = LogManager.getLogger(SolrServiceMetadataBrowseIndexingPlugin.class);
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected MetadataAuthorityService metadataAuthorityService;
    @Autowired(required=true)
    protected ChoiceAuthorityService choiceAuthorityService;

    @Override
    public void additionalIndex(Context context, IndexableObject indexableObject, SolrInputDocument document) {
        BrowseIndex[] bis;
        if (!(indexableObject instanceof IndexableItem)) {
            return;
        }
        Item item = (Item)((IndexableItem)indexableObject).getIndexedObject();
        try {
            bis = BrowseIndex.getBrowseIndices();
        }
        catch (BrowseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
        for (BrowseIndex bi : bis) {
            log.debug("Indexing for item " + item.getID() + ", for index: " + bi.getTableName());
            if (!bi.isMetadataIndex()) continue;
            bi.generateMdBits();
            HashSet<CallSite> distFValues = new HashSet<CallSite>();
            HashSet<String> distFVal = new HashSet<String>();
            HashSet<String> distFAuths = new HashSet<String>();
            HashSet<String> distValuesForAC = new HashSet<String>();
            if (item.isArchived() || item.isWithdrawn()) {
                for (int mdIdx = 0; mdIdx < bi.getMetadataCount(); ++mdIdx) {
                    String[] stringArray = bi.getMdBits(mdIdx);
                    List<MetadataValue> values = this.itemService.getMetadata(item, stringArray[0], stringArray[1], stringArray[2], "*");
                    if (values == null || values.size() <= 0) continue;
                    int minConfidence = this.metadataAuthorityService.getMinConfidence(values.get(0).getMetadataField());
                    boolean ignoreAuthority = (Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore." + bi.getName(), (Object)((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore", (Object)new Boolean(false))), true);
                    for (int x = 0; x < values.size(); ++x) {
                        if (StringUtils.isEmpty((CharSequence)values.get(x).getValue())) {
                            log.error("Null metadata value for item " + item.getID() + ", field: " + values.get(x).getMetadataField().toString());
                            continue;
                        }
                        if (bi.isAuthorityIndex() && (values.get(x).getAuthority() == null || values.get(x).getConfidence() < minConfidence)) {
                            log.debug("Skipping item=" + item.getID() + ", field=" + values.get(x).getMetadataField().toString() + ", value=" + values.get(x).getValue() + ", authority=" + values.get(x).getAuthority() + ", confidence=" + values.get(x).getConfidence() + " (BAD AUTHORITY)");
                            continue;
                        }
                        if (ignoreAuthority && !bi.isAuthorityIndex() || values.get(x).getAuthority() != null && values.get(x).getConfidence() >= minConfidence) {
                            distFAuths.add(values.get(x).getAuthority());
                            distValuesForAC.add(values.get(x).getValue());
                            String preferedLabel = null;
                            boolean ignorePrefered = (Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore-prefered." + bi.getName(), (Object)((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore-prefered", (Object)new Boolean(false))), true);
                            if (!ignorePrefered) {
                                preferedLabel = this.choiceAuthorityService.getLabel(values.get(x), values.get(x).getLanguage());
                            }
                            List<String> variants = null;
                            boolean ignoreVariants = (Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore-variants." + bi.getName(), (Object)((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore-variants", (Object)new Boolean(false))), true);
                            if (!ignoreVariants) {
                                variants = this.choiceAuthorityService.getVariants(values.get(x));
                            }
                            if (StringUtils.isNotBlank((CharSequence)preferedLabel)) {
                                String nLabel = OrderFormat.makeSortString(preferedLabel, values.get(x).getLanguage(), bi.getDataType());
                                distFValues.add((CallSite)((Object)(nLabel + "\n|||\n" + preferedLabel + "###" + values.get(x).getAuthority())));
                                distValuesForAC.add(preferedLabel);
                            }
                            if (variants == null) continue;
                            for (String var : variants) {
                                String nVal = OrderFormat.makeSortString(var, values.get(x).getLanguage(), bi.getDataType());
                                distFValues.add((CallSite)((Object)(nVal + "\n|||\n" + var + "###" + values.get(x).getAuthority())));
                                distValuesForAC.add(var);
                            }
                            continue;
                        }
                        String nVal = OrderFormat.makeSortString(values.get(x).getValue(), values.get(x).getLanguage(), bi.getDataType());
                        distFValues.add((CallSite)((Object)(nVal + "\n|||\n" + values.get(x).getValue())));
                        distFVal.add(values.get(x).getValue());
                        distValuesForAC.add(values.get(x).getValue());
                    }
                }
            }
            for (String string : distFValues) {
                document.addField(bi.getDistinctTableName() + "_filter", (Object)string);
            }
            for (String string : distFAuths) {
                document.addField(bi.getDistinctTableName() + "_authority_filter", (Object)string);
            }
            for (String string : distValuesForAC) {
                document.addField(bi.getDistinctTableName() + "_partial", (Object)string);
            }
            for (String string : distFVal) {
                document.addField(bi.getDistinctTableName() + "_value_filter", (Object)string);
            }
        }
        try {
            for (SortOption so : SortOption.getSortOptions()) {
                List<MetadataValue> dcvalue = this.itemService.getMetadataByMetadataString(item, so.getMetadata());
                if (dcvalue == null || dcvalue.size() <= 0) continue;
                String nValue = OrderFormat.makeSortString(dcvalue.get(0).getValue(), dcvalue.get(0).getLanguage(), so.getType());
                document.addField("bi_sort_" + so.getNumber() + "_sort", (Object)nValue);
            }
        }
        catch (SortException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

