/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.indexobject;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.indexobject.IndexableWorkspaceItem;
import org.dspace.discovery.indexobject.InprogressSubmissionIndexFactoryImpl;
import org.dspace.discovery.indexobject.factory.WorkspaceItemIndexFactory;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkspaceItemIndexFactoryImpl
extends InprogressSubmissionIndexFactoryImpl<IndexableWorkspaceItem, WorkspaceItem>
implements WorkspaceItemIndexFactory {
    @Autowired
    protected WorkspaceItemService workspaceItemService;

    @Override
    public Iterator<IndexableWorkspaceItem> findAll(Context context) throws SQLException {
        final Iterator<WorkspaceItem> workspaceItems = this.workspaceItemService.findAll(context).iterator();
        return new Iterator<IndexableWorkspaceItem>(){

            @Override
            public boolean hasNext() {
                return workspaceItems.hasNext();
            }

            @Override
            public IndexableWorkspaceItem next() {
                return new IndexableWorkspaceItem((WorkspaceItem)workspaceItems.next());
            }
        };
    }

    @Override
    public String getType() {
        return IndexableWorkspaceItem.TYPE;
    }

    @Override
    public SolrInputDocument buildDocument(Context context, IndexableWorkspaceItem indexableObject) throws SQLException, IOException {
        SolrInputDocument doc = super.buildDocument(context, indexableObject);
        String acvalue = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.facet.namedtype.workspace");
        if (StringUtils.isBlank((CharSequence)acvalue)) {
            acvalue = indexableObject.getTypeText();
        }
        this.addNamedResourceTypeIndex(doc, acvalue);
        WorkspaceItem inProgressSubmission = (WorkspaceItem)indexableObject.getIndexedObject();
        List<DiscoveryConfiguration> discoveryConfigurations = SearchUtils.getAllDiscoveryConfigurations(inProgressSubmission);
        this.indexableItemService.addDiscoveryFields(doc, context, inProgressSubmission.getItem(), discoveryConfigurations);
        return doc;
    }

    @Override
    public boolean supports(Object object) {
        return object instanceof WorkspaceItem;
    }

    @Override
    public List getIndexableObjects(Context context, WorkspaceItem object) {
        return Arrays.asList(new IndexableWorkspaceItem(object));
    }

    @Override
    public Optional<IndexableWorkspaceItem> findIndexableObject(Context context, String id) throws SQLException {
        WorkspaceItem workspaceItem = this.workspaceItemService.find(context, Integer.parseInt(id));
        return workspaceItem == null ? Optional.empty() : Optional.of(new IndexableWorkspaceItem(workspaceItem));
    }
}

