/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external;

import java.io.InputStream;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrcidRestConnector {
    private static Logger log = LogManager.getLogger(OrcidRestConnector.class);
    private String url;

    public OrcidRestConnector(String url) {
        this.url = url;
    }

    public InputStream get(String path, String accessToken) {
        InputStream result = null;
        path = OrcidRestConnector.trimSlashes(path);
        String fullPath = this.url + "/" + path;
        HttpGet httpGet = new HttpGet(fullPath);
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            httpGet.addHeader("Content-Type", "application/vnd.orcid+xml");
            httpGet.addHeader("Authorization", "Bearer " + accessToken);
        }
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse getResponse = httpClient.execute((HttpUriRequest)httpGet);
            result = getResponse.getEntity().getContent();
        }
        catch (Exception e) {
            this.getGotError(e, fullPath);
        }
        return result;
    }

    protected void getGotError(Exception e, String fullPath) {
        log.error("Error in rest connector for path: " + fullPath, (Throwable)e);
    }

    public static String trimSlashes(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

