/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DCPersonName;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.ExternalDataProvider;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LCNameDataProvider
implements ExternalDataProvider {
    private static final Logger log = LogManager.getLogger(LCNameDataProvider.class);
    private String url;
    private String sourceIdentifier;
    protected static final String NS_SRU = "http://www.loc.gov/zing/srw/";
    protected static final String NS_MX = "http://www.loc.gov/MARC21/slim";

    @Override
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    @Override
    public Optional<ExternalDataObject> getExternalDataObject(String id) {
        StringBuilder query = new StringBuilder();
        query.append("local.LCCN = \"").append(id).append("\"");
        List<ExternalDataObject> list = this.doLookup(0, 10, query);
        if (list.size() > 0) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    @Override
    public List<ExternalDataObject> searchExternalDataObjects(String text, int start, int limit) {
        if (text == null || text.trim().length() == 0) {
            return Collections.EMPTY_LIST;
        }
        DCPersonName pn = new DCPersonName(text);
        StringBuilder query = new StringBuilder();
        query.append("local.FirstName = \"").append(pn.getFirstNames()).append("\" and local.FamilyName = \"").append(pn.getLastName()).append("\"");
        return this.doLookup(start, limit, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExternalDataObject> doLookup(int start, int limit, StringBuilder query) {
        if (limit == 0) {
            limit = 50;
        }
        HttpGet get = this.constructHttpGet(query, start, limit);
        try {
            DefaultHttpClient hc = new DefaultHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                SRUHandler handler = this.parseResponseToSRUHandler(response);
                if (handler.hits != handler.result.size()) {
                    log.warn("Discrepency in results, result.length=" + handler.result.size() + ", yet expected results=" + handler.hits);
                }
                List<ExternalDataObject> list = handler.result;
                return list;
            }
        }
        catch (IOException e) {
            log.error("SRU query failed: ", (Throwable)e);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        catch (ParserConfigurationException e) {
            log.warn("Failed parsing SRU result: ", (Throwable)e);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        catch (SAXException e) {
            log.warn("Failed parsing SRU result: ", (Throwable)e);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            get.releaseConnection();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean supports(String source) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.sourceIdentifier, (CharSequence)source);
    }

    private HttpGet constructHttpGet(StringBuilder query, int start, int limit) {
        URI sruUri;
        try {
            URIBuilder builder = new URIBuilder(this.url);
            builder.addParameter("operation", "searchRetrieve");
            builder.addParameter("version", "1.1");
            builder.addParameter("recordSchema", "info:srw/schema/1/marcxml-v1.1");
            builder.addParameter("query", query.toString());
            builder.addParameter("maximumRecords", String.valueOf(limit));
            builder.addParameter("startRecord", String.valueOf(start + 1));
            sruUri = builder.build();
        }
        catch (URISyntaxException e) {
            log.error("SRU query failed: ", (Throwable)e);
            return null;
        }
        HttpGet get = new HttpGet(sruUri);
        log.debug("Trying SRU query, URL=" + sruUri);
        return get;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfResults(String query) {
        if (query == null || query.trim().length() == 0) {
            return 0;
        }
        DCPersonName pn = new DCPersonName(query);
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append("local.FirstName = \"").append(pn.getFirstNames()).append("\" and local.FamilyName = \"").append(pn.getLastName()).append("\"");
        HttpGet get = this.constructHttpGet(queryStringBuilder, 0, 1);
        try {
            DefaultHttpClient hc = new DefaultHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                SRUHandler handler = this.parseResponseToSRUHandler(response);
                int n = handler.hits;
                return n;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.warn("Failed parsing SRU result: ", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            get.releaseConnection();
        }
        return 0;
    }

    private SRUHandler parseResponseToSRUHandler(HttpResponse response) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser sp = spf.newSAXParser();
        XMLReader xr = sp.getXMLReader();
        SRUHandler handler = new SRUHandler(this.sourceIdentifier);
        xr.setFeature("http://xml.org/sax/features/namespaces", true);
        xr.setContentHandler(handler);
        xr.setErrorHandler(handler);
        HttpEntity responseBody = response.getEntity();
        xr.parse(new InputSource(responseBody.getContent()));
        return handler;
    }

    private static class SRUHandler
    extends DefaultHandler {
        private String sourceIdentifier;
        private List<ExternalDataObject> result = new ArrayList<ExternalDataObject>();
        private int hits = -1;
        private String textValue = null;
        private String name = null;
        private String birthDate = null;
        private String lccn = null;
        private String lastTag = null;
        private String lastCode = null;

        public SRUHandler(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String newValue = new String(ch, start, length);
            if (newValue.length() > 0) {
                this.textValue = this.textValue == null ? newValue : this.textValue + newValue;
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("numberOfRecords") && namespaceURI.equals(LCNameDataProvider.NS_SRU)) {
                this.hits = Integer.parseInt(this.textValue.trim());
                if (this.hits > 0) {
                    this.name = null;
                    this.lccn = null;
                    log.debug("Expecting " + this.hits + " records in results.");
                }
            } else if (localName.equals("record") && namespaceURI.equals(LCNameDataProvider.NS_SRU)) {
                if (this.name != null && this.lccn != null) {
                    String givenName;
                    if (this.name.endsWith(",")) {
                        this.name = this.name.substring(0, this.name.length() - 1);
                    }
                    ExternalDataObject externalDataObject = new ExternalDataObject(this.sourceIdentifier);
                    externalDataObject.setDisplayValue(this.name);
                    externalDataObject.setValue(this.name);
                    externalDataObject.setId(this.lccn);
                    String[] names = this.name.split(", ");
                    String familyName = names[0];
                    String string = givenName = names.length > 1 ? names[1] : null;
                    if (StringUtils.isNotBlank((CharSequence)familyName)) {
                        externalDataObject.addMetadata(new MetadataValueDTO("person", "familyName", null, null, familyName));
                    }
                    if (StringUtils.isNotBlank((CharSequence)givenName)) {
                        externalDataObject.addMetadata(new MetadataValueDTO("person", "givenName", null, null, givenName));
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.birthDate)) {
                        externalDataObject.addMetadata(new MetadataValueDTO("person", "date", "birth", null, this.birthDate));
                    }
                    externalDataObject.addMetadata(new MetadataValueDTO("person", "identifier", "lccn", null, this.lccn));
                    this.result.add(externalDataObject);
                } else {
                    log.warn("Got anomalous result, at least one of these null: lccn=" + this.lccn + ", name=" + this.name);
                }
                this.name = null;
                this.lccn = null;
                this.birthDate = null;
            } else if (localName.equals("subfield") && namespaceURI.equals(LCNameDataProvider.NS_MX) && this.lastTag != null && this.lastCode != null) {
                if (this.lastTag.equals("010") && this.lastCode.equals("a")) {
                    this.lccn = this.textValue;
                } else if (this.lastTag.equals("100") && this.lastCode.equals("a")) {
                    this.name = this.textValue;
                }
                if (this.lastTag.equals("100") && this.lastCode.equals("d")) {
                    this.birthDate = this.textValue;
                }
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.textValue = null;
            if (localName.equals("datafield") && namespaceURI.equals(LCNameDataProvider.NS_MX)) {
                this.lastTag = atts.getValue("tag");
                if (this.lastTag == null) {
                    log.warn("MARC datafield without tag attribute!");
                }
            } else if (localName.equals("subfield") && namespaceURI.equals(LCNameDataProvider.NS_MX)) {
                this.lastCode = atts.getValue("code");
                if (this.lastCode == null) {
                    log.warn("MARC subfield without code attribute!");
                }
            }
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }
    }
}

