/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.sherpa.SHERPAJournal;
import org.dspace.app.sherpa.SHERPAResponse;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.ExternalDataProvider;

public class SherpaJournalDataProvider
implements ExternalDataProvider {
    private static final Logger log = LogManager.getLogger(SherpaJournalDataProvider.class);
    private String url;
    private String sourceIdentifier;
    private String apiKey;
    private CloseableHttpClient client = null;

    @Override
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void init() throws IOException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        this.client = builder.disableAutomaticRetries().setMaxConnTotal(5).build();
    }

    @Override
    public Optional<ExternalDataObject> getExternalDataObject(String id) {
        HttpGet method = null;
        SHERPAResponse sherpaResponse = null;
        int timeout = 5000;
        URIBuilder uriBuilder = null;
        try {
            HttpEntity responseBody;
            uriBuilder = new URIBuilder(this.url);
            uriBuilder.addParameter("jtitle", id);
            if (StringUtils.isNotBlank((CharSequence)this.apiKey)) {
                uriBuilder.addParameter("ak", this.apiKey);
            }
            method = new HttpGet(uriBuilder.build());
            method.setConfig(RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).build());
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                sherpaResponse = new SHERPAResponse("SHERPA/RoMEO return not OK status: " + statusCode);
            }
            sherpaResponse = null != (responseBody = response.getEntity()) ? new SHERPAResponse(responseBody.getContent()) : new SHERPAResponse("SHERPA/RoMEO returned no response");
        }
        catch (Exception e) {
            log.error("SHERPA/RoMEO query failed: ", (Throwable)e);
        }
        if (sherpaResponse == null) {
            sherpaResponse = new SHERPAResponse("Error processing the SHERPA/RoMEO answer");
        }
        if (CollectionUtils.isNotEmpty(sherpaResponse.getJournals())) {
            SHERPAJournal sherpaJournal = sherpaResponse.getJournals().get(0);
            ExternalDataObject externalDataObject = this.constructExternalDataObjectFromSherpaJournal(sherpaJournal);
            return Optional.of(externalDataObject);
        }
        return null;
    }

    private ExternalDataObject constructExternalDataObjectFromSherpaJournal(SHERPAJournal sherpaJournal) {
        ExternalDataObject externalDataObject = new ExternalDataObject();
        externalDataObject.setSource(this.sourceIdentifier);
        externalDataObject.setId(sherpaJournal.getTitle());
        externalDataObject.addMetadata(new MetadataValueDTO("dc", "title", null, null, sherpaJournal.getTitle()));
        externalDataObject.addMetadata(new MetadataValueDTO("dc", "identifier", "issn", null, sherpaJournal.getIssn()));
        externalDataObject.setValue(sherpaJournal.getTitle());
        externalDataObject.setDisplayValue(sherpaJournal.getTitle());
        return externalDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExternalDataObject> searchExternalDataObjects(String query, int start, int limit) {
        HttpGet get = this.constructHttpGet(query);
        try {
            DefaultHttpClient hc = new DefaultHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                SHERPAResponse sherpaResponse = new SHERPAResponse(response.getEntity().getContent());
                List list = sherpaResponse.getJournals().stream().map(sherpaJournal -> this.constructExternalDataObjectFromSherpaJournal((SHERPAJournal)sherpaJournal)).collect(Collectors.toList());
                List<ExternalDataObject> list2 = list.subList(start, Math.min(start + limit, list.size()));
                return list2;
            }
        }
        catch (IOException e) {
            log.error("SHERPA/RoMEO query failed: ", (Throwable)e);
            List<ExternalDataObject> list = null;
            return list;
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    private HttpGet constructHttpGet(String query) {
        ArrayList<BasicNameValuePair> args = new ArrayList<BasicNameValuePair>();
        args.add(new BasicNameValuePair("jtitle", query));
        args.add(new BasicNameValuePair("qtype", "contains"));
        args.add(new BasicNameValuePair("ak", this.apiKey));
        String srUrl = this.url + "?" + URLEncodedUtils.format(args, (String)"UTF8");
        return new HttpGet(srUrl);
    }

    @Override
    public boolean supports(String source) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.sourceIdentifier, (CharSequence)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfResults(String query) {
        HttpGet get = this.constructHttpGet(query);
        try {
            DefaultHttpClient hc = new DefaultHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                SHERPAResponse sherpaResponse = new SHERPAResponse(response.getEntity().getContent());
                int n = sherpaResponse.getNumHits();
                return n;
            }
        }
        catch (IOException e) {
            log.error("SHERPA/RoMEO query failed: ", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            get.releaseConnection();
        }
        return 0;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }
}

