/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.license;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.license.LicenseMetadataValue;
import org.dspace.license.service.CreativeCommonsService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom.Document;
import org.jdom.transform.JDOMSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class CreativeCommonsServiceImpl
implements CreativeCommonsService,
InitializingBean {
    private static Logger log = LogManager.getLogger(CreativeCommonsServiceImpl.class);
    protected static final String CC_BS_SOURCE = "org.dspace.license.CreativeCommons";
    @Deprecated
    protected static final String BSN_LICENSE_URL = "license_url";
    @Deprecated
    protected static final String BSN_LICENSE_TEXT = "license_text";
    protected static final String BSN_LICENSE_RDF = "license_rdf";
    protected Templates templates;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected BitstreamFormatService bitstreamFormatService;
    @Autowired(required=true)
    protected BundleService bundleService;
    @Autowired(required=true)
    protected ItemService itemService;
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    protected CreativeCommonsServiceImpl() {
    }

    public void afterPropertiesSet() throws Exception {
        String proxyHost = this.configurationService.getProperty("http.proxy.host");
        String proxyPort = this.configurationService.getProperty("http.proxy.port");
        if (StringUtils.isNotBlank((CharSequence)proxyHost) && StringUtils.isNotBlank((CharSequence)proxyPort)) {
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", proxyPort);
        }
        try {
            this.templates = TransformerFactory.newInstance().newTemplates(new StreamSource(CreativeCommonsServiceImpl.class.getResourceAsStream("CreativeCommons.xsl")));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    protected Bundle getCcBundle(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        List<Bundle> bundles = this.itemService.getBundles(item, "CC-LICENSE");
        if (bundles.size() > 0 && bundles.get(0) != null) {
            this.itemService.removeBundle(context, item, bundles.get(0));
        }
        return this.bundleService.create(context, item, "CC-LICENSE");
    }

    @Override
    public void setLicenseRDF(Context context, Item item, String licenseRdf) throws SQLException, IOException, AuthorizeException {
        Bundle bundle = this.getCcBundle(context, item);
        BitstreamFormat bs_rdf_format = this.bitstreamFormatService.findByShortDescription(context, "RDF XML");
        this.setBitstreamFromBytes(context, item, bundle, BSN_LICENSE_RDF, bs_rdf_format, licenseRdf.getBytes());
    }

    @Override
    public void setLicense(Context context, Item item, InputStream licenseStm, String mimeType) throws SQLException, IOException, AuthorizeException {
        Bundle bundle = this.getCcBundle(context, item);
        BitstreamFormat bs_format = mimeType.equalsIgnoreCase("text/xml") ? this.bitstreamFormatService.findByShortDescription(context, "CC License") : (mimeType.equalsIgnoreCase("text/rdf") ? this.bitstreamFormatService.findByShortDescription(context, "RDF XML") : this.bitstreamFormatService.findByShortDescription(context, "License"));
        Bitstream bs = this.bitstreamService.create(context, bundle, licenseStm);
        bs.setSource(context, CC_BS_SOURCE);
        bs.setName(context, mimeType != null && (mimeType.equalsIgnoreCase("text/xml") || mimeType.equalsIgnoreCase("text/rdf")) ? BSN_LICENSE_RDF : BSN_LICENSE_TEXT);
        bs.setFormat(context, bs_format);
        this.bitstreamService.update(context, bs);
    }

    @Override
    public void removeLicense(Context context, Item item) throws SQLException, IOException, AuthorizeException {
        List<Bundle> bundles = this.itemService.getBundles(item, "CC-LICENSE");
        if (bundles.size() > 0 && bundles.get(0) != null) {
            this.itemService.removeBundle(context, item, bundles.get(0));
        }
    }

    @Override
    public boolean hasLicense(Context context, Item item) throws SQLException, IOException {
        List<Bundle> bundles = this.itemService.getBundles(item, "CC-LICENSE");
        if (bundles.size() == 0) {
            return false;
        }
        try {
            if (this.getLicenseURL(context, item) == null) {
                return false;
            }
        }
        catch (AuthorizeException ae) {
            return false;
        }
        return true;
    }

    @Override
    public String getLicenseRDF(Context context, Item item) throws SQLException, IOException, AuthorizeException {
        return this.getStringFromBitstream(context, item, BSN_LICENSE_RDF);
    }

    @Override
    public Bitstream getLicenseRdfBitstream(Item item) throws SQLException, IOException, AuthorizeException {
        return this.getBitstream(item, BSN_LICENSE_RDF);
    }

    @Override
    @Deprecated
    public Bitstream getLicenseTextBitstream(Item item) throws SQLException, IOException, AuthorizeException {
        return this.getBitstream(item, BSN_LICENSE_TEXT);
    }

    @Override
    public String getLicenseURL(Context context, Item item) throws SQLException, IOException, AuthorizeException {
        String licenseUri = this.getCCField("uri").ccItemValue(item);
        if (StringUtils.isNotBlank((CharSequence)licenseUri)) {
            return licenseUri;
        }
        return this.getStringFromBitstream(context, item, BSN_LICENSE_URL);
    }

    @Override
    public String fetchLicenseRDF(Document license) {
        StringWriter result = new StringWriter();
        try {
            this.templates.newTransformer().transform((Source)new JDOMSource(license), new StreamResult(result));
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return result.getBuffer().toString();
    }

    protected void setBitstreamFromBytes(Context context, Item item, Bundle bundle, String bitstream_name, BitstreamFormat format, byte[] bytes) throws SQLException, IOException, AuthorizeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        Bitstream bs = this.bitstreamService.create(context, bundle, bais);
        bs.setName(context, bitstream_name);
        bs.setSource(context, CC_BS_SOURCE);
        bs.setFormat(context, format);
        this.bitstreamService.update(context, bs);
    }

    protected String getStringFromBitstream(Context context, Item item, String bitstream_name) throws SQLException, IOException, AuthorizeException {
        byte[] bytes = this.getBytesFromBitstream(context, item, bitstream_name);
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    protected Bitstream getBitstream(Item item, String bitstream_name) throws SQLException, IOException, AuthorizeException {
        Bundle cc_bundle = null;
        try {
            List<Bundle> bundles = this.itemService.getBundles(item, "CC-LICENSE");
            if (bundles == null || bundles.size() <= 0) {
                return null;
            }
            cc_bundle = bundles.get(0);
        }
        catch (Exception exc) {
            return null;
        }
        return this.bundleService.getBitstreamByName(cc_bundle, bitstream_name);
    }

    protected byte[] getBytesFromBitstream(Context context, Item item, String bitstream_name) throws SQLException, IOException, AuthorizeException {
        Bitstream bs = this.getBitstream(item, bitstream_name);
        if (bs == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Utils.copy(this.bitstreamService.retrieve(context, bs), baos);
        return baos.toByteArray();
    }

    @Override
    public LicenseMetadataValue getCCField(String fieldId) {
        return new LicenseMetadataValue(this.configurationService.getProperty("cc.license." + fieldId));
    }

    @Override
    public void removeLicense(Context context, LicenseMetadataValue uriField, LicenseMetadataValue nameField, Item item) throws AuthorizeException, IOException, SQLException {
        String licenseUri = uriField.ccItemValue(item);
        if (licenseUri != null) {
            uriField.removeItemValue(context, item, licenseUri);
            if (this.configurationService.getBooleanProperty("cc.submit.setname")) {
                String licenseName = nameField.keyedItemValue(item, licenseUri);
                nameField.removeItemValue(context, item, licenseName);
            }
            if (this.configurationService.getBooleanProperty("cc.submit.addbitstream")) {
                this.removeLicense(context, item);
            }
        }
    }
}

