/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.content;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.content.Item;
import org.dspace.statistics.content.filter.StatisticsFilter;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.statistics.service.SolrLoggerService;

public class StatisticsBSAdapter {
    protected boolean displayItemViews = false;
    protected boolean displayBitstreamViews = false;
    protected boolean displayTotalViews;
    protected List<StatisticsFilter> filters = new ArrayList<StatisticsFilter>();
    public static final int ITEM_VISITS = 0;
    public static final int BITSTREAM_VISITS = 1;
    public static final int TOTAL_VISITS = 2;
    protected final SolrLoggerService solrLoggerService = StatisticsServiceFactory.getInstance().getSolrLoggerService();

    public long getNumberOfVisits(int visitType, Item item) throws SolrServerException, IOException {
        switch (visitType) {
            case 0: {
                return this.solrLoggerService.queryTotal("type: 2 AND id: " + item.getID(), this.resolveFilterQueries()).getCount();
            }
            case 1: {
                return this.solrLoggerService.queryTotal("type: 0 AND owningItem: " + item.getID(), this.resolveFilterQueries()).getCount();
            }
            case 2: {
                return this.getNumberOfVisits(0, item) + this.getNumberOfVisits(1, item);
            }
        }
        return -1L;
    }

    private String resolveFilterQueries() {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < this.filters.size(); ++i) {
            StatisticsFilter statisticsFilter = this.filters.get(i);
            out.append(statisticsFilter.toQuery());
            if (i == 0 || i == this.filters.size() - 1) continue;
            out.append(" AND ");
        }
        return out.toString();
    }

    public boolean isDisplayTotalViews() {
        return this.displayTotalViews;
    }

    public void setDisplayTotalViews(boolean displayTotalViews) {
        this.displayTotalViews = displayTotalViews;
    }

    public boolean isDisplayItemViews() {
        return this.displayItemViews;
    }

    public void setDisplayItemViews(boolean displayItemViews) {
        this.displayItemViews = displayItemViews;
    }

    public boolean isDisplayBitstreamViews() {
        return this.displayBitstreamViews;
    }

    public void setDisplayBitstreamViews(boolean displayBitstreamViews) {
        this.displayBitstreamViews = displayBitstreamViews;
    }

    public List<StatisticsFilter> getFilters() {
        return this.filters;
    }

    public void addFilter(StatisticsFilter filter) {
        this.filters.add(filter);
    }

    public void setFilters(List<StatisticsFilter> filters) {
        this.filters = filters;
    }
}

