/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.content;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.Dataset;
import org.dspace.statistics.ObjectCount;
import org.dspace.statistics.SolrLoggerServiceImpl;
import org.dspace.statistics.content.DatasetGenerator;
import org.dspace.statistics.content.DatasetTypeGenerator;
import org.dspace.statistics.content.StatisticsData;
import org.dspace.statistics.content.filter.StatisticsFilter;

public class StatisticsDataWorkflow
extends StatisticsData {
    private static final Logger log = LogManager.getLogger(StatisticsDataWorkflow.class);
    private DSpaceObject currentDso;
    private int averageMonths = -1;

    public StatisticsDataWorkflow(DSpaceObject dso, int averageMonths) {
        this.currentDso = dso;
        this.averageMonths = averageMonths;
    }

    @Override
    public Dataset createDataset(Context context) throws SQLException, SolrServerException, IOException, ParseException {
        DatasetGenerator datasetGenerator;
        if (this.getDataset() != null) {
            return this.getDataset();
        }
        List<StatisticsFilter> filters = this.getFilters();
        ArrayList<String> defaultFilters = new ArrayList<String>();
        for (StatisticsFilter statisticsFilter : filters) {
            defaultFilters.add(statisticsFilter.toQuery());
        }
        String defaultFilterQuery = StringUtils.join(defaultFilters.iterator(), (String)" AND ");
        String query = this.getQuery();
        Dataset dataset = new Dataset(0, 0);
        List<DatasetGenerator> datasetGenerators = this.getDatasetGenerators();
        if (0 < datasetGenerators.size() && (datasetGenerator = datasetGenerators.get(0)) instanceof DatasetTypeGenerator) {
            DatasetTypeGenerator typeGenerator = (DatasetTypeGenerator)datasetGenerator;
            ObjectCount[] topCounts = this.solrLoggerService.queryFacetField(query, defaultFilterQuery, typeGenerator.getType(), typeGenerator.getMax(), typeGenerator.isIncludeTotal(), null);
            Map<Object, Object> totalFieldCounts = new HashMap();
            if (this.averageMonths != -1) {
                totalFieldCounts = this.getTotalFacetCounts(typeGenerator);
            }
            long monthDifference = 1L;
            if (this.getOldestWorkflowItemDate() != null) {
                monthDifference = this.getMonthsDifference(new Date(), this.getOldestWorkflowItemDate());
            }
            dataset = new Dataset(topCounts.length, this.averageMonths != -1 ? 3 : 2);
            dataset.setColLabel(0, "step");
            dataset.setColLabel(1, "performed");
            if (this.averageMonths != -1) {
                dataset.setColLabel(2, "average");
            }
            for (int i = 0; i < topCounts.length; ++i) {
                ObjectCount topCount = topCounts[i];
                dataset.setRowLabel(i, String.valueOf(i + 1));
                dataset.addValueToMatrix(i, 0, topCount.getValue());
                dataset.addValueToMatrix(i, 1, topCount.getCount());
                if (this.averageMonths == -1) continue;
                long monthlyAverage = 0L;
                if (totalFieldCounts.get(topCount.getValue()) != null) {
                    monthlyAverage = (Long)totalFieldCounts.get(topCount.getValue()) / monthDifference;
                }
                dataset.addValueToMatrix(i, 2, monthlyAverage * (long)this.averageMonths);
            }
        }
        return dataset;
    }

    protected String getQuery() {
        String query = "statistics_type:" + SolrLoggerServiceImpl.StatisticsType.WORKFLOW.text();
        query = query + " AND NOT(previousWorkflowStep: SUBMIT)";
        if (this.currentDso != null) {
            if (this.currentDso.getType() == 4) {
                query = query + " AND owningComm:";
            } else if (this.currentDso.getType() == 3) {
                query = query + " AND owningColl:";
            }
            query = query + this.currentDso.getID();
        }
        return query;
    }

    private int getMonthsDifference(Date date1, Date date2) {
        int m1 = date1.getYear() * 12 + date1.getMonth();
        int m2 = date2.getYear() * 12 + date2.getMonth();
        return m2 - m1 + 1;
    }

    protected Map<String, Long> getTotalFacetCounts(DatasetTypeGenerator typeGenerator) throws SolrServerException, IOException {
        ObjectCount[] objectCounts = this.solrLoggerService.queryFacetField(this.getQuery(), null, typeGenerator.getType(), -1, false, null);
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (ObjectCount objectCount : objectCounts) {
            result.put(objectCount.getValue(), objectCount.getCount());
        }
        return result;
    }

    protected Date getOldestWorkflowItemDate() throws SolrServerException, IOException {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        String workflowStartDate = configurationService.getProperty("usage-statistics.workflow-start-date");
        if (workflowStartDate == null) {
            QueryResponse oldestRecord = this.solrLoggerService.query(this.getQuery(), null, null, 1, 0, null, null, null, null, "time", true);
            if (0L < oldestRecord.getResults().getNumFound()) {
                SolrDocument solrDocument = (SolrDocument)oldestRecord.getResults().get(0);
                Date oldestDate = (Date)solrDocument.getFieldValue("time");
                try {
                    String solrConfigDir = configurationService.getProperty("dspace.dir") + File.separator + "config" + File.separator + "modules" + File.separator + "usage-statistics.cfg";
                    FileBasedConfigurationBuilder builder = new Configurations().propertiesBuilder(solrConfigDir);
                    PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
                    config.setProperty("workflow-start-date", (Object)new DCDate(oldestDate));
                    builder.save();
                }
                catch (ConfigurationException e) {
                    log.error("Error while storing workflow start date", (Throwable)e);
                }
                configurationService.setProperty("usage-statistics.workflow-start-date", (Object)new DCDate(oldestDate).toString());
                return oldestDate;
            }
            return null;
        }
        return new DCDate(workflowStartDate).toDate();
    }
}

