/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms.xmlworkflow;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.flywaydb.core.api.migration.MigrationChecksumProvider;
import org.flywaydb.core.api.migration.jdbc.JdbcMigration;
import org.flywaydb.core.internal.util.scanner.classpath.ClassPathResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V5_0_2014_11_04__Enable_XMLWorkflow_Migration
implements JdbcMigration,
MigrationChecksumProvider {
    private static final Logger log = LoggerFactory.getLogger(V5_0_2014_11_04__Enable_XMLWorkflow_Migration.class);
    Integer migration_file_size = -1;

    public void migrate(Connection connection) throws IOException, SQLException {
        if (WorkflowServiceFactory.getInstance().getWorkflowService() instanceof XmlWorkflowService && DatabaseUtils.getCurrentFlywayDSpaceState(connection) < 6.0 && !DatabaseUtils.tableExists(connection, "cwf_workflowitem")) {
            String dbtype = connection.getMetaData().getDatabaseProductName();
            String dbFileLocation = null;
            if (dbtype.toLowerCase().contains("postgres")) {
                dbFileLocation = "postgres";
            } else if (dbtype.toLowerCase().contains("oracle")) {
                dbFileLocation = "oracle";
            } else if (dbtype.toLowerCase().contains("h2")) {
                dbFileLocation = "h2";
            }
            String packagePath = V5_0_2014_11_04__Enable_XMLWorkflow_Migration.class.getPackage().getName().replace(".", "/");
            String dbMigrateSQL = new ClassPathResource(packagePath + "/" + dbFileLocation + "/xml_workflow_migration.sql", this.getClass().getClassLoader()).loadAsString("UTF-8");
            DatabaseUtils.executeSql(connection, dbMigrateSQL);
            String dataMigrateSQL = new ClassPathResource(packagePath + "/" + dbFileLocation + "/data_workflow_migration.sql", this.getClass().getClassLoader()).loadAsString("UTF-8");
            DatabaseUtils.executeSql(connection, dataMigrateSQL);
            this.migration_file_size = dbMigrateSQL.length() + dataMigrateSQL.length();
        }
    }

    public Integer getChecksum() {
        return this.migration_file_size;
    }
}

