/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.Value;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.submit.lookup.LookupProvidersCheck;

public class SubmissionLookupUtils {
    private static Logger log = LogManager.getLogger(SubmissionLookupUtils.class);
    private static final String configFilePath = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "crosswalks" + File.separator;
    private static final Pattern converterPattern = Pattern.compile(".*\\((.*)\\)");
    protected static final MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    private SubmissionLookupUtils() {
    }

    public static LookupProvidersCheck getProvidersCheck(Context context, Item item, String dcSchema, String dcElement, String dcQualifier) {
        try {
            LookupProvidersCheck check = new LookupProvidersCheck();
            List<MetadataSchema> schemas = metadataSchemaService.findAll(context);
            List<MetadataValue> values = itemService.getMetadata(item, dcSchema, dcElement, dcQualifier, "*");
            for (MetadataSchema schema : schemas) {
                List<MetadataValue> slCache;
                boolean error = false;
                if (!schema.getNamespace().startsWith("http://www.dspace.org/sl/") || (slCache = itemService.getMetadata(item, schema.getName(), dcElement, dcQualifier, "*")).size() == 0) continue;
                if (slCache.size() != values.size()) {
                    error = true;
                } else {
                    for (int idx = 0; idx < values.size(); ++idx) {
                        MetadataValue v = values.get(idx);
                        MetadataValue sl = slCache.get(idx);
                        if (v.getValue().equals(sl.getValue())) continue;
                        error = true;
                        break;
                    }
                }
                if (error) {
                    check.getProvidersErr().add(schema.getName());
                    continue;
                }
                check.getProvidersOk().add(schema.getName());
            }
            return check;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String normalizeDOI(String doi) {
        if (doi != null) {
            return doi.trim().replaceAll("^http://dx.doi.org/", "").replaceAll("^doi:", "");
        }
        return null;
    }

    public static String getFirstValue(Record rec, String field) {
        List values = rec.getValues(field);
        String value = null;
        if (values != null && values.size() > 0) {
            value = ((Value)values.get(0)).getAsString();
        }
        return value;
    }

    public static List<String> getValues(Record rec, String field) {
        ArrayList<String> result = new ArrayList<String>();
        List values = rec.getValues(field);
        if (values != null && values.size() > 0) {
            for (Value value : values) {
                result.add(value.getAsString());
            }
        }
        return result;
    }

    public static String getPrintableString(Record record) {
        StringBuilder result = new StringBuilder();
        result.append("\nPublication {\n");
        for (String field : record.getFields()) {
            result.append("--" + field + ":\n");
            List values = record.getValues(field);
            for (Value value : values) {
                result.append("\t" + value.getAsString() + "\n");
            }
        }
        result.append("}\n");
        return result.toString();
    }
}

