/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.ReloadableEntity;
import org.dspace.versioning.Version;
import org.hibernate.proxy.HibernateProxyHelper;

@Entity
@Table(name="versionhistory")
public class VersionHistory
implements ReloadableEntity<Integer> {
    private static final Logger log = LogManager.getLogger(VersionHistory.class);
    @Id
    @Column(name="versionhistory_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="versionhistory_seq")
    @SequenceGenerator(name="versionhistory_seq", sequenceName="versionhistory_seq", allocationSize=1)
    private Integer id;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="versionHistory")
    @OrderBy(value="versionNumber desc")
    private List<Version> versions = new ArrayList<Version>();

    protected VersionHistory() {
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    protected List<Version> getVersions() {
        return this.versions;
    }

    void setVersions(List<Version> versions) {
        this.versions = versions;
    }

    void addVersionAtStart(Version version) {
        this.versions.add(0, version);
    }

    void removeVersion(Version version) {
        this.versions.remove(version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)o);
        if (this.getClass() != objClass) {
            return false;
        }
        VersionHistory that = (VersionHistory)o;
        return this.getID() == that.getID();
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.getID();
        return hash;
    }
}

