/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import java.sql.SQLException;
import java.util.List;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.xmlworkflow.RoleMembers;
import org.dspace.xmlworkflow.storedcomponents.CollectionRole;
import org.dspace.xmlworkflow.storedcomponents.WorkflowItemRole;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.CollectionRoleService;
import org.dspace.xmlworkflow.storedcomponents.service.WorkflowItemRoleService;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class Role
implements BeanNameAware {
    @Autowired
    private GroupService groupService;
    @Autowired
    private CollectionRoleService collectionRoleService;
    @Autowired
    private WorkflowItemRoleService workflowItemRoleService;
    private String id;
    private String name;
    private String description;
    private boolean isInternal = false;
    private Scope scope = Scope.COLLECTION;

    public void setBeanName(String s) {
        this.id = s;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public Scope getScope() {
        return this.scope;
    }

    public RoleMembers getMembers(Context context, XmlWorkflowItem wfi) throws SQLException {
        if (this.scope == Scope.REPOSITORY) {
            Group group = this.groupService.findByName(context, this.name);
            if (group == null) {
                return new RoleMembers();
            }
            RoleMembers assignees = new RoleMembers();
            assignees.addGroup(group);
            return assignees;
        }
        if (this.scope == Scope.COLLECTION) {
            CollectionRole collectionRole = this.collectionRoleService.find(context, wfi.getCollection(), this.id);
            if (collectionRole != null) {
                RoleMembers assignees = new RoleMembers();
                assignees.addGroup(collectionRole.getGroup());
                return assignees;
            }
            return new RoleMembers();
        }
        List<WorkflowItemRole> roles = this.workflowItemRoleService.find(context, wfi, this.id);
        RoleMembers assignees = new RoleMembers();
        for (WorkflowItemRole itemRole : roles) {
            Group group;
            EPerson user = itemRole.getEPerson();
            if (user != null) {
                assignees.addEPerson(user);
            }
            if ((group = itemRole.getGroup()) == null) continue;
            assignees.addGroup(group);
        }
        return assignees;
    }

    @Required
    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setInternal(boolean internal) {
        this.isInternal = internal;
    }

    public static enum Scope {
        REPOSITORY,
        COLLECTION,
        ITEM;

    }
}

