/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.UserSelectionActionConfig;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.InProgressUserService;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class Step
implements BeanNameAware {
    @Autowired
    protected InProgressUserService inProgressUserService;
    private UserSelectionActionConfig userSelectionMethod;
    private List<WorkflowActionConfig> actions;
    private Map<Integer, Step> outcomes = new HashMap<Integer, Step>();
    private String id;
    private Role role;
    private Workflow workflow;
    private int requiredUsers = 1;

    public WorkflowActionConfig getActionConfig(String actionID) throws WorkflowConfigurationException {
        if (this.userSelectionMethod != null && StringUtils.equals((CharSequence)this.userSelectionMethod.getId(), (CharSequence)actionID)) {
            return this.userSelectionMethod;
        }
        for (WorkflowActionConfig actionConfig : this.actions) {
            if (!StringUtils.equals((CharSequence)actionConfig.getId(), (CharSequence)actionID)) continue;
            return actionConfig;
        }
        throw new WorkflowConfigurationException("Action configuration not found for: " + actionID);
    }

    public boolean hasUI() {
        for (WorkflowActionConfig actionConfig : this.actions) {
            if (!actionConfig.requiresUI()) continue;
            return true;
        }
        return false;
    }

    public Step getNextStep(int outcome) {
        return this.outcomes.get(outcome);
    }

    public boolean isValidStep(Context context, XmlWorkflowItem wfi) throws WorkflowConfigurationException, SQLException {
        return this.getUserSelectionMethod() != null && this.getUserSelectionMethod().getProcessingAction() != null && this.getUserSelectionMethod().getProcessingAction().isValidUserSelection(context, wfi, this.hasUI());
    }

    public UserSelectionActionConfig getUserSelectionMethod() {
        return this.userSelectionMethod;
    }

    public WorkflowActionConfig getNextAction(WorkflowActionConfig currentAction) {
        int index = this.actions.indexOf(currentAction);
        if (index < this.actions.size() - 1) {
            return this.actions.get(index + 1);
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public boolean isFinished(Context c, XmlWorkflowItem wfi) throws SQLException {
        return this.inProgressUserService.getNumberOfFinishedUsers(c, wfi) == this.requiredUsers;
    }

    public int getRequiredUsers() {
        return this.requiredUsers;
    }

    public Role getRole() {
        return this.role;
    }

    @Required
    public void setUserSelectionMethod(UserSelectionActionConfig userSelectionMethod) {
        this.userSelectionMethod = userSelectionMethod;
        userSelectionMethod.setStep(this);
    }

    public void setOutcomes(Map<Integer, Step> outcomes) {
        this.outcomes = outcomes;
    }

    public List<WorkflowActionConfig> getActions() {
        return this.actions;
    }

    @Required
    public void setActions(List<WorkflowActionConfig> actions) {
        for (WorkflowActionConfig workflowActionConfig : actions) {
            workflowActionConfig.setStep(this);
        }
        this.actions = actions;
    }

    protected void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    public void setBeanName(String s) {
        this.id = s;
    }

    public void setRequiredUsers(int requiredUsers) {
        this.requiredUsers = requiredUsers;
    }

    public void setRole(Role role) {
        this.role = role;
    }
}

