/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.ArrayUtils;
import org.dspace.app.mediafilter.FormatFilter;
import org.dspace.app.mediafilter.factory.MediaFilterServiceFactory;
import org.dspace.app.mediafilter.service.MediaFilterService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.services.factory.DSpaceServicesFactory;

public class MediaFilterCLITool {
    private static final String MEDIA_FILTER_PLUGINS_KEY = "filter.plugins";
    private static final String FILTER_PREFIX = "filter";
    private static final String INPUT_FORMATS_SUFFIX = "inputFormats";

    private MediaFilterCLITool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        HelpFormatter myhelp;
        System.setProperty("java.awt.headless", "true");
        PosixParser parser = new PosixParser();
        int status = 0;
        Options options = new Options();
        options.addOption("v", "verbose", false, "print all extracted text and other details to STDOUT");
        options.addOption("q", "quiet", false, "do not print anything except in the event of errors.");
        options.addOption("f", "force", false, "force all bitstreams to be processed");
        options.addOption("i", "identifier", true, "ONLY process bitstreams belonging to identifier");
        options.addOption("m", "maximum", true, "process no more than maximum items");
        options.addOption("h", "help", false, "help");
        OptionBuilder.withLongOpt((String)"plugins");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"ONLY run the specified Media Filter plugin(s)\nlisted from 'filter.plugins' in dspace.cfg.\nSeparate multiple with a comma (,)\n(e.g. MediaFilterManager -p \n\"Word Text Extractor\",\"PDF Text Extractor\")");
        Option pluginOption = OptionBuilder.create((char)'p');
        pluginOption.setArgs(-2);
        options.addOption(pluginOption);
        OptionBuilder.withLongOpt((String)"skip");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"SKIP the bitstreams belonging to identifier\nSeparate multiple identifiers with a comma (,)\n(e.g. MediaFilterManager -s \n 123456789/34,123456789/323)");
        Option skipOption = OptionBuilder.create((char)'s');
        skipOption.setArgs(-2);
        options.addOption(skipOption);
        boolean isVerbose = false;
        boolean isQuiet = false;
        boolean isForce = false;
        String identifier = null;
        int max2Process = Integer.MAX_VALUE;
        HashMap<String, List<String>> filterFormats = new HashMap<String, List<String>>();
        CommandLine line = null;
        try {
            line = parser.parse(options, argv);
        }
        catch (MissingArgumentException e) {
            System.out.println("ERROR: " + e.getMessage());
            myhelp = new HelpFormatter();
            myhelp.printHelp("MediaFilterManager\n", options);
            System.exit(1);
        }
        if (line.hasOption('h')) {
            HelpFormatter myhelp2 = new HelpFormatter();
            myhelp2.printHelp("MediaFilterManager\n", options);
            System.exit(0);
        }
        if (line.hasOption('v')) {
            isVerbose = true;
        }
        isQuiet = line.hasOption('q');
        if (line.hasOption('f')) {
            isForce = true;
        }
        if (line.hasOption('i')) {
            identifier = line.getOptionValue('i');
        }
        if (line.hasOption('m') && (max2Process = Integer.parseInt(line.getOptionValue('m'))) <= 1) {
            System.out.println("Invalid maximum value '" + line.getOptionValue('m') + "' - ignoring");
            max2Process = Integer.MAX_VALUE;
        }
        String[] filterNames = null;
        if (line.hasOption('p')) {
            filterNames = line.getOptionValues('p');
            if (filterNames == null || filterNames.length == 0) {
                System.err.println("\nERROR: -p (-plugin) option requires at least one plugin to be specified.\n(e.g. MediaFilterManager -p \"Word Text Extractor\",\"PDF Text Extractor\")\n");
                myhelp = new HelpFormatter();
                myhelp.printHelp("MediaFilterManager\n", options);
                System.exit(1);
            }
        } else {
            filterNames = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty(MEDIA_FILTER_PLUGINS_KEY);
        }
        MediaFilterService mediaFilterService = MediaFilterServiceFactory.getInstance().getMediaFilterService();
        mediaFilterService.setForce(isForce);
        mediaFilterService.setQuiet(isQuiet);
        mediaFilterService.setVerbose(isVerbose);
        mediaFilterService.setMax2Process(max2Process);
        ArrayList<FormatFilter> filterList = new ArrayList<FormatFilter>();
        for (int i = 0; i < filterNames.length; ++i) {
            Object[] formats;
            FormatFilter filter = (FormatFilter)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(FormatFilter.class, filterNames[i]);
            if (filter == null) {
                System.err.println("\nERROR: Unknown MediaFilter specified (either from command-line or in dspace.cfg): '" + filterNames[i] + "'");
                System.exit(1);
                continue;
            }
            filterList.add(filter);
            String filterClassName = filter.getClass().getName();
            String pluginName = null;
            if (SelfNamedPlugin.class.isAssignableFrom(filter.getClass())) {
                pluginName = ((SelfNamedPlugin)((Object)filter)).getPluginInstanceName();
            }
            if (!ArrayUtils.isNotEmpty((Object[])(formats = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("filter." + filterClassName + (String)(pluginName != null ? "." + pluginName : "") + ".inputFormats")))) continue;
            filterFormats.put(filterClassName + (String)(pluginName != null ? "\u001c" + pluginName : ""), Arrays.asList(formats));
        }
        if (isVerbose) {
            System.out.println("The following MediaFilters are enabled: ");
            for (String filterName : filterFormats.keySet()) {
                System.out.println("Full Filter Name: " + filterName);
                String pluginName = null;
                if (filterName.contains("\u001c")) {
                    String[] fields = filterName.split("\u001c");
                    filterName = fields[0];
                    pluginName = fields[1];
                }
                System.out.println(filterName + (String)(pluginName != null ? " (Plugin: " + pluginName + ")" : ""));
            }
        }
        mediaFilterService.setFilterFormats(filterFormats);
        mediaFilterService.setFilterClasses(filterList);
        String[] skipIds = null;
        if (line.hasOption('s')) {
            skipIds = line.getOptionValues('s');
            if (skipIds == null || skipIds.length == 0) {
                System.err.println("\nERROR: -s (-skip) option requires at least one identifier to SKIP.\nMake sure to separate multiple identifiers with a comma!\n(e.g. MediaFilterManager -s 123456789/34,123456789/323)\n");
                HelpFormatter myhelp3 = new HelpFormatter();
                myhelp3.printHelp("MediaFilterManager\n", options);
                System.exit(0);
            }
            mediaFilterService.setSkipList(Arrays.asList(skipIds));
        }
        Context c = null;
        try {
            c = new Context();
            c.turnOffAuthorisationSystem();
            if (identifier == null) {
                mediaFilterService.applyFiltersAllItems(c);
            } else {
                DSpaceObject dso = HandleServiceFactory.getInstance().getHandleService().resolveToObject(c, identifier);
                if (dso == null) {
                    throw new IllegalArgumentException("Cannot resolve " + identifier + " to a DSpace object");
                }
                switch (dso.getType()) {
                    case 4: {
                        mediaFilterService.applyFiltersCommunity(c, (Community)dso);
                        break;
                    }
                    case 3: {
                        mediaFilterService.applyFiltersCollection(c, (Collection)dso);
                        break;
                    }
                    case 2: {
                        mediaFilterService.applyFiltersItem(c, (Item)dso);
                        break;
                    }
                }
            }
            c.complete();
            c = null;
        }
        catch (Exception e) {
            status = 1;
        }
        finally {
            if (c != null) {
                c.abort();
            }
        }
        System.exit(status);
    }
}

