/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.POITextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.content.Item;

public class PowerPointFilter
extends MediaFilter {
    private static Logger log = LogManager.getLogger(PowerPointFilter.class);

    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".txt";
    }

    @Override
    public String getBundleName() {
        return "TEXT";
    }

    @Override
    public String getFormatString() {
        return "Text";
    }

    @Override
    public String getDescription() {
        return "Extracted text";
    }

    @Override
    public InputStream getDestinationStream(Item currentItem, InputStream source, boolean verbose) throws Exception {
        try {
            Object extractedText = null;
            new ExtractorFactory();
            POITextExtractor pptExtractor = ExtractorFactory.createExtractor((InputStream)source);
            if (pptExtractor instanceof XSLFPowerPointExtractor) {
                extractedText = ((XSLFPowerPointExtractor)pptExtractor).getText(true, true);
            } else if (pptExtractor instanceof PowerPointExtractor) {
                extractedText = ((PowerPointExtractor)pptExtractor).getText() + " " + ((PowerPointExtractor)pptExtractor).getNotes();
            }
            if (extractedText != null) {
                if (verbose) {
                    System.out.println((String)extractedText);
                }
                byte[] textBytes = ((String)extractedText).getBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(textBytes);
                return bais;
            }
        }
        catch (Exception e) {
            log.error("Error filtering bitstream: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return null;
    }
}

